package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class FileSDConfigBuilder extends FileSDConfigFluent<FileSDConfigBuilder> implements VisitableBuilder<FileSDConfig,FileSDConfigBuilder>{
  public FileSDConfigBuilder() {
    this(new FileSDConfig());
  }
  
  public FileSDConfigBuilder(FileSDConfigFluent<?> fluent) {
    this(fluent, new FileSDConfig());
  }
  
  public FileSDConfigBuilder(FileSDConfigFluent<?> fluent,FileSDConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FileSDConfigBuilder(FileSDConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FileSDConfigFluent<?> fluent;
  
  public FileSDConfig build() {
    FileSDConfig buildable = new FileSDConfig(fluent.getFiles(),fluent.getRefreshInterval());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}