package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WebhookConfigBuilder extends WebhookConfigFluent<WebhookConfigBuilder> implements VisitableBuilder<WebhookConfig,WebhookConfigBuilder>{
  public WebhookConfigBuilder() {
    this(new WebhookConfig());
  }
  
  public WebhookConfigBuilder(WebhookConfigFluent<?> fluent) {
    this(fluent, new WebhookConfig());
  }
  
  public WebhookConfigBuilder(WebhookConfigFluent<?> fluent,WebhookConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WebhookConfigBuilder(WebhookConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WebhookConfigFluent<?> fluent;
  
  public WebhookConfig build() {
    WebhookConfig buildable = new WebhookConfig(fluent.buildHttpConfig(),fluent.getMaxAlerts(),fluent.getSendResolved(),fluent.getTimeout(),fluent.getUrl(),fluent.getUrlSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}