package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class WebhookConfigFluent<A extends WebhookConfigFluent<A>> extends BaseFluent<A>{
  public WebhookConfigFluent() {
  }
  
  public WebhookConfigFluent(WebhookConfig instance) {
    this.copyInstance(instance);
  }
  private HTTPConfigBuilder httpConfig;
  private Integer maxAlerts;
  private Boolean sendResolved;
  private String timeout;
  private String url;
  private SecretKeySelector urlSecret;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(WebhookConfig instance) {
    instance = (instance != null ? instance : new WebhookConfig());
    if (instance != null) {
          this.withHttpConfig(instance.getHttpConfig());
          this.withMaxAlerts(instance.getMaxAlerts());
          this.withSendResolved(instance.getSendResolved());
          this.withTimeout(instance.getTimeout());
          this.withUrl(instance.getUrl());
          this.withUrlSecret(instance.getUrlSecret());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig != null ? this.httpConfig.build() : null;
  }
  
  public A withHttpConfig(HTTPConfig httpConfig) {
    this._visitables.remove("httpConfig");
    if (httpConfig != null) {
        this.httpConfig = new HTTPConfigBuilder(httpConfig);
        this._visitables.get("httpConfig").add(this.httpConfig);
    } else {
        this.httpConfig = null;
        this._visitables.get("httpConfig").remove(this.httpConfig);
    }
    return (A) this;
  }
  
  public boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  
  public HttpConfigNested<A> withNewHttpConfig() {
    return new HttpConfigNested(null);
  }
  
  public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new HttpConfigNested(item);
  }
  
  public HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(null));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(item));
  }
  
  public Integer getMaxAlerts() {
    return this.maxAlerts;
  }
  
  public A withMaxAlerts(Integer maxAlerts) {
    this.maxAlerts = maxAlerts;
    return (A) this;
  }
  
  public boolean hasMaxAlerts() {
    return this.maxAlerts != null;
  }
  
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved = sendResolved;
    return (A) this;
  }
  
  public boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  
  public String getTimeout() {
    return this.timeout;
  }
  
  public A withTimeout(String timeout) {
    this.timeout = timeout;
    return (A) this;
  }
  
  public boolean hasTimeout() {
    return this.timeout != null;
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public SecretKeySelector getUrlSecret() {
    return this.urlSecret;
  }
  
  public A withUrlSecret(SecretKeySelector urlSecret) {
    this.urlSecret = urlSecret;
    return (A) this;
  }
  
  public boolean hasUrlSecret() {
    return this.urlSecret != null;
  }
  
  public A withNewUrlSecret(String key,String name,Boolean optional) {
    return (A)withUrlSecret(new SecretKeySelector(key, name, optional));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WebhookConfigFluent that = (WebhookConfigFluent) o;
    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;
    if (!java.util.Objects.equals(maxAlerts, that.maxAlerts)) return false;
    if (!java.util.Objects.equals(sendResolved, that.sendResolved)) return false;
    if (!java.util.Objects.equals(timeout, that.timeout)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(urlSecret, that.urlSecret)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(httpConfig,  maxAlerts,  sendResolved,  timeout,  url,  urlSecret,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (maxAlerts != null) { sb.append("maxAlerts:"); sb.append(maxAlerts + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (urlSecret != null) { sb.append("urlSecret:"); sb.append(urlSecret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSendResolved() {
    return withSendResolved(true);
  }
  public class HttpConfigNested<N> extends HTTPConfigFluent<HttpConfigNested<N>> implements Nested<N>{
    HttpConfigNested(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HTTPConfigBuilder builder;
    
    public N and() {
      return (N) WebhookConfigFluent.this.withHttpConfig(builder.build());
    }
    
    public N endHttpConfig() {
      return and();
    }
    
  
  }

}