package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EmailConfigBuilder extends EmailConfigFluent<EmailConfigBuilder> implements VisitableBuilder<EmailConfig,EmailConfigBuilder>{
  public EmailConfigBuilder() {
    this(new EmailConfig());
  }
  
  public EmailConfigBuilder(EmailConfigFluent<?> fluent) {
    this(fluent, new EmailConfig());
  }
  
  public EmailConfigBuilder(EmailConfigFluent<?> fluent,EmailConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EmailConfigBuilder(EmailConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EmailConfigFluent<?> fluent;
  
  public EmailConfig build() {
    EmailConfig buildable = new EmailConfig(fluent.getAuthIdentity(),fluent.buildAuthPassword(),fluent.buildAuthSecret(),fluent.getAuthUsername(),fluent.getFrom(),fluent.buildHeaders(),fluent.getHello(),fluent.getHtml(),fluent.getRequireTLS(),fluent.getSendResolved(),fluent.getSmarthost(),fluent.getText(),fluent.buildTlsConfig(),fluent.getTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}