package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PagerDutyConfigFluent<A extends PagerDutyConfigFluent<A>> extends BaseFluent<A>{
  public PagerDutyConfigFluent() {
  }
  
  public PagerDutyConfigFluent(PagerDutyConfig instance) {
    this.copyInstance(instance);
  }
  private String className;
  private String client;
  private String clientURL;
  private String component;
  private String description;
  private ArrayList<KeyValueBuilder> details = new ArrayList<KeyValueBuilder>();
  private String group;
  private HTTPConfigBuilder httpConfig;
  private ArrayList<PagerDutyImageConfigBuilder> pagerDutyImageConfigs = new ArrayList<PagerDutyImageConfigBuilder>();
  private ArrayList<PagerDutyLinkConfigBuilder> pagerDutyLinkConfigs = new ArrayList<PagerDutyLinkConfigBuilder>();
  private SecretKeySelectorBuilder routingKey;
  private Boolean sendResolved;
  private SecretKeySelectorBuilder serviceKey;
  private String severity;
  private String source;
  private String url;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PagerDutyConfig instance) {
    instance = (instance != null ? instance : new PagerDutyConfig());
    if (instance != null) {
          this.withClassName(instance.getClassName());
          this.withClient(instance.getClient());
          this.withClientURL(instance.getClientURL());
          this.withComponent(instance.getComponent());
          this.withDescription(instance.getDescription());
          this.withDetails(instance.getDetails());
          this.withGroup(instance.getGroup());
          this.withHttpConfig(instance.getHttpConfig());
          this.withPagerDutyImageConfigs(instance.getPagerDutyImageConfigs());
          this.withPagerDutyLinkConfigs(instance.getPagerDutyLinkConfigs());
          this.withRoutingKey(instance.getRoutingKey());
          this.withSendResolved(instance.getSendResolved());
          this.withServiceKey(instance.getServiceKey());
          this.withSeverity(instance.getSeverity());
          this.withSource(instance.getSource());
          this.withUrl(instance.getUrl());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClassName() {
    return this.className;
  }
  
  public A withClassName(String className) {
    this.className = className;
    return (A) this;
  }
  
  public boolean hasClassName() {
    return this.className != null;
  }
  
  public String getClient() {
    return this.client;
  }
  
  public A withClient(String client) {
    this.client = client;
    return (A) this;
  }
  
  public boolean hasClient() {
    return this.client != null;
  }
  
  public String getClientURL() {
    return this.clientURL;
  }
  
  public A withClientURL(String clientURL) {
    this.clientURL = clientURL;
    return (A) this;
  }
  
  public boolean hasClientURL() {
    return this.clientURL != null;
  }
  
  public String getComponent() {
    return this.component;
  }
  
  public A withComponent(String component) {
    this.component = component;
    return (A) this;
  }
  
  public boolean hasComponent() {
    return this.component != null;
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public A withDescription(String description) {
    this.description = description;
    return (A) this;
  }
  
  public boolean hasDescription() {
    return this.description != null;
  }
  
  public A addToDetails(int index,KeyValue item) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);
    if (index < 0 || index >= details.size()) {
        _visitables.get("details").add(builder);
        details.add(builder);
    } else {
        _visitables.get("details").add(builder);
        details.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToDetails(int index,KeyValue item) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);
    if (index < 0 || index >= details.size()) {
        _visitables.get("details").add(builder);
        details.add(builder);
    } else {
        _visitables.get("details").add(builder);
        details.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToDetails(io.fabric8.openshift.api.model.monitoring.v1beta1.KeyValue... items) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  
  public A addAllToDetails(Collection<KeyValue> items) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  
  public A removeFromDetails(io.fabric8.openshift.api.model.monitoring.v1beta1.KeyValue... items) {
    if (this.details == null) return (A)this;
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").remove(builder); this.details.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDetails(Collection<KeyValue> items) {
    if (this.details == null) return (A)this;
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").remove(builder); this.details.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDetails(Predicate<KeyValueBuilder> predicate) {
    if (details == null) return (A) this;
    final Iterator<KeyValueBuilder> each = details.iterator();
    final List visitables = _visitables.get("details");
    while (each.hasNext()) {
      KeyValueBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<KeyValue> buildDetails() {
    return this.details != null ? build(details) : null;
  }
  
  public KeyValue buildDetail(int index) {
    return this.details.get(index).build();
  }
  
  public KeyValue buildFirstDetail() {
    return this.details.get(0).build();
  }
  
  public KeyValue buildLastDetail() {
    return this.details.get(details.size() - 1).build();
  }
  
  public KeyValue buildMatchingDetail(Predicate<KeyValueBuilder> predicate) {
      for (KeyValueBuilder item : details) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDetail(Predicate<KeyValueBuilder> predicate) {
      for (KeyValueBuilder item : details) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDetails(List<KeyValue> details) {
    if (this.details != null) {
      this._visitables.get("details").clear();
    }
    if (details != null) {
        this.details = new ArrayList();
        for (KeyValue item : details) {
          this.addToDetails(item);
        }
    } else {
      this.details = null;
    }
    return (A) this;
  }
  
  public A withDetails(io.fabric8.openshift.api.model.monitoring.v1beta1.KeyValue... details) {
    if (this.details != null) {
        this.details.clear();
        _visitables.remove("details");
    }
    if (details != null) {
      for (KeyValue item : details) {
        this.addToDetails(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDetails() {
    return this.details != null && !this.details.isEmpty();
  }
  
  public A addNewDetail(String key,String value) {
    return (A)addToDetails(new KeyValue(key, value));
  }
  
  public DetailsNested<A> addNewDetail() {
    return new DetailsNested(-1, null);
  }
  
  public DetailsNested<A> addNewDetailLike(KeyValue item) {
    return new DetailsNested(-1, item);
  }
  
  public DetailsNested<A> setNewDetailLike(int index,KeyValue item) {
    return new DetailsNested(index, item);
  }
  
  public DetailsNested<A> editDetail(int index) {
    if (details.size() <= index) throw new RuntimeException("Can't edit details. Index exceeds size.");
    return setNewDetailLike(index, buildDetail(index));
  }
  
  public DetailsNested<A> editFirstDetail() {
    if (details.size() == 0) throw new RuntimeException("Can't edit first details. The list is empty.");
    return setNewDetailLike(0, buildDetail(0));
  }
  
  public DetailsNested<A> editLastDetail() {
    int index = details.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last details. The list is empty.");
    return setNewDetailLike(index, buildDetail(index));
  }
  
  public DetailsNested<A> editMatchingDetail(Predicate<KeyValueBuilder> predicate) {
    int index = -1;
    for (int i=0;i<details.size();i++) { 
    if (predicate.test(details.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching details. No match found.");
    return setNewDetailLike(index, buildDetail(index));
  }
  
  public String getGroup() {
    return this.group;
  }
  
  public A withGroup(String group) {
    this.group = group;
    return (A) this;
  }
  
  public boolean hasGroup() {
    return this.group != null;
  }
  
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig != null ? this.httpConfig.build() : null;
  }
  
  public A withHttpConfig(HTTPConfig httpConfig) {
    this._visitables.remove("httpConfig");
    if (httpConfig != null) {
        this.httpConfig = new HTTPConfigBuilder(httpConfig);
        this._visitables.get("httpConfig").add(this.httpConfig);
    } else {
        this.httpConfig = null;
        this._visitables.get("httpConfig").remove(this.httpConfig);
    }
    return (A) this;
  }
  
  public boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  
  public HttpConfigNested<A> withNewHttpConfig() {
    return new HttpConfigNested(null);
  }
  
  public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new HttpConfigNested(item);
  }
  
  public HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(null));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(item));
  }
  
  public A addToPagerDutyImageConfigs(int index,PagerDutyImageConfig item) {
    if (this.pagerDutyImageConfigs == null) {this.pagerDutyImageConfigs = new ArrayList<PagerDutyImageConfigBuilder>();}
    PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);
    if (index < 0 || index >= pagerDutyImageConfigs.size()) {
        _visitables.get("pagerDutyImageConfigs").add(builder);
        pagerDutyImageConfigs.add(builder);
    } else {
        _visitables.get("pagerDutyImageConfigs").add(builder);
        pagerDutyImageConfigs.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToPagerDutyImageConfigs(int index,PagerDutyImageConfig item) {
    if (this.pagerDutyImageConfigs == null) {this.pagerDutyImageConfigs = new ArrayList<PagerDutyImageConfigBuilder>();}
    PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);
    if (index < 0 || index >= pagerDutyImageConfigs.size()) {
        _visitables.get("pagerDutyImageConfigs").add(builder);
        pagerDutyImageConfigs.add(builder);
    } else {
        _visitables.get("pagerDutyImageConfigs").add(builder);
        pagerDutyImageConfigs.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToPagerDutyImageConfigs(io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyImageConfig... items) {
    if (this.pagerDutyImageConfigs == null) {this.pagerDutyImageConfigs = new ArrayList<PagerDutyImageConfigBuilder>();}
    for (PagerDutyImageConfig item : items) {PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);_visitables.get("pagerDutyImageConfigs").add(builder);this.pagerDutyImageConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToPagerDutyImageConfigs(Collection<PagerDutyImageConfig> items) {
    if (this.pagerDutyImageConfigs == null) {this.pagerDutyImageConfigs = new ArrayList<PagerDutyImageConfigBuilder>();}
    for (PagerDutyImageConfig item : items) {PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);_visitables.get("pagerDutyImageConfigs").add(builder);this.pagerDutyImageConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromPagerDutyImageConfigs(io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyImageConfig... items) {
    if (this.pagerDutyImageConfigs == null) return (A)this;
    for (PagerDutyImageConfig item : items) {PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);_visitables.get("pagerDutyImageConfigs").remove(builder); this.pagerDutyImageConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPagerDutyImageConfigs(Collection<PagerDutyImageConfig> items) {
    if (this.pagerDutyImageConfigs == null) return (A)this;
    for (PagerDutyImageConfig item : items) {PagerDutyImageConfigBuilder builder = new PagerDutyImageConfigBuilder(item);_visitables.get("pagerDutyImageConfigs").remove(builder); this.pagerDutyImageConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPagerDutyImageConfigs(Predicate<PagerDutyImageConfigBuilder> predicate) {
    if (pagerDutyImageConfigs == null) return (A) this;
    final Iterator<PagerDutyImageConfigBuilder> each = pagerDutyImageConfigs.iterator();
    final List visitables = _visitables.get("pagerDutyImageConfigs");
    while (each.hasNext()) {
      PagerDutyImageConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PagerDutyImageConfig> buildPagerDutyImageConfigs() {
    return this.pagerDutyImageConfigs != null ? build(pagerDutyImageConfigs) : null;
  }
  
  public PagerDutyImageConfig buildPagerDutyImageConfig(int index) {
    return this.pagerDutyImageConfigs.get(index).build();
  }
  
  public PagerDutyImageConfig buildFirstPagerDutyImageConfig() {
    return this.pagerDutyImageConfigs.get(0).build();
  }
  
  public PagerDutyImageConfig buildLastPagerDutyImageConfig() {
    return this.pagerDutyImageConfigs.get(pagerDutyImageConfigs.size() - 1).build();
  }
  
  public PagerDutyImageConfig buildMatchingPagerDutyImageConfig(Predicate<PagerDutyImageConfigBuilder> predicate) {
      for (PagerDutyImageConfigBuilder item : pagerDutyImageConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPagerDutyImageConfig(Predicate<PagerDutyImageConfigBuilder> predicate) {
      for (PagerDutyImageConfigBuilder item : pagerDutyImageConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPagerDutyImageConfigs(List<PagerDutyImageConfig> pagerDutyImageConfigs) {
    if (this.pagerDutyImageConfigs != null) {
      this._visitables.get("pagerDutyImageConfigs").clear();
    }
    if (pagerDutyImageConfigs != null) {
        this.pagerDutyImageConfigs = new ArrayList();
        for (PagerDutyImageConfig item : pagerDutyImageConfigs) {
          this.addToPagerDutyImageConfigs(item);
        }
    } else {
      this.pagerDutyImageConfigs = null;
    }
    return (A) this;
  }
  
  public A withPagerDutyImageConfigs(io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyImageConfig... pagerDutyImageConfigs) {
    if (this.pagerDutyImageConfigs != null) {
        this.pagerDutyImageConfigs.clear();
        _visitables.remove("pagerDutyImageConfigs");
    }
    if (pagerDutyImageConfigs != null) {
      for (PagerDutyImageConfig item : pagerDutyImageConfigs) {
        this.addToPagerDutyImageConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPagerDutyImageConfigs() {
    return this.pagerDutyImageConfigs != null && !this.pagerDutyImageConfigs.isEmpty();
  }
  
  public A addNewPagerDutyImageConfig(String alt,String href,String src) {
    return (A)addToPagerDutyImageConfigs(new PagerDutyImageConfig(alt, href, src));
  }
  
  public PagerDutyImageConfigsNested<A> addNewPagerDutyImageConfig() {
    return new PagerDutyImageConfigsNested(-1, null);
  }
  
  public PagerDutyImageConfigsNested<A> addNewPagerDutyImageConfigLike(PagerDutyImageConfig item) {
    return new PagerDutyImageConfigsNested(-1, item);
  }
  
  public PagerDutyImageConfigsNested<A> setNewPagerDutyImageConfigLike(int index,PagerDutyImageConfig item) {
    return new PagerDutyImageConfigsNested(index, item);
  }
  
  public PagerDutyImageConfigsNested<A> editPagerDutyImageConfig(int index) {
    if (pagerDutyImageConfigs.size() <= index) throw new RuntimeException("Can't edit pagerDutyImageConfigs. Index exceeds size.");
    return setNewPagerDutyImageConfigLike(index, buildPagerDutyImageConfig(index));
  }
  
  public PagerDutyImageConfigsNested<A> editFirstPagerDutyImageConfig() {
    if (pagerDutyImageConfigs.size() == 0) throw new RuntimeException("Can't edit first pagerDutyImageConfigs. The list is empty.");
    return setNewPagerDutyImageConfigLike(0, buildPagerDutyImageConfig(0));
  }
  
  public PagerDutyImageConfigsNested<A> editLastPagerDutyImageConfig() {
    int index = pagerDutyImageConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last pagerDutyImageConfigs. The list is empty.");
    return setNewPagerDutyImageConfigLike(index, buildPagerDutyImageConfig(index));
  }
  
  public PagerDutyImageConfigsNested<A> editMatchingPagerDutyImageConfig(Predicate<PagerDutyImageConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<pagerDutyImageConfigs.size();i++) { 
    if (predicate.test(pagerDutyImageConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching pagerDutyImageConfigs. No match found.");
    return setNewPagerDutyImageConfigLike(index, buildPagerDutyImageConfig(index));
  }
  
  public A addToPagerDutyLinkConfigs(int index,PagerDutyLinkConfig item) {
    if (this.pagerDutyLinkConfigs == null) {this.pagerDutyLinkConfigs = new ArrayList<PagerDutyLinkConfigBuilder>();}
    PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);
    if (index < 0 || index >= pagerDutyLinkConfigs.size()) {
        _visitables.get("pagerDutyLinkConfigs").add(builder);
        pagerDutyLinkConfigs.add(builder);
    } else {
        _visitables.get("pagerDutyLinkConfigs").add(builder);
        pagerDutyLinkConfigs.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToPagerDutyLinkConfigs(int index,PagerDutyLinkConfig item) {
    if (this.pagerDutyLinkConfigs == null) {this.pagerDutyLinkConfigs = new ArrayList<PagerDutyLinkConfigBuilder>();}
    PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);
    if (index < 0 || index >= pagerDutyLinkConfigs.size()) {
        _visitables.get("pagerDutyLinkConfigs").add(builder);
        pagerDutyLinkConfigs.add(builder);
    } else {
        _visitables.get("pagerDutyLinkConfigs").add(builder);
        pagerDutyLinkConfigs.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToPagerDutyLinkConfigs(io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyLinkConfig... items) {
    if (this.pagerDutyLinkConfigs == null) {this.pagerDutyLinkConfigs = new ArrayList<PagerDutyLinkConfigBuilder>();}
    for (PagerDutyLinkConfig item : items) {PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);_visitables.get("pagerDutyLinkConfigs").add(builder);this.pagerDutyLinkConfigs.add(builder);} return (A)this;
  }
  
  public A addAllToPagerDutyLinkConfigs(Collection<PagerDutyLinkConfig> items) {
    if (this.pagerDutyLinkConfigs == null) {this.pagerDutyLinkConfigs = new ArrayList<PagerDutyLinkConfigBuilder>();}
    for (PagerDutyLinkConfig item : items) {PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);_visitables.get("pagerDutyLinkConfigs").add(builder);this.pagerDutyLinkConfigs.add(builder);} return (A)this;
  }
  
  public A removeFromPagerDutyLinkConfigs(io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyLinkConfig... items) {
    if (this.pagerDutyLinkConfigs == null) return (A)this;
    for (PagerDutyLinkConfig item : items) {PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);_visitables.get("pagerDutyLinkConfigs").remove(builder); this.pagerDutyLinkConfigs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPagerDutyLinkConfigs(Collection<PagerDutyLinkConfig> items) {
    if (this.pagerDutyLinkConfigs == null) return (A)this;
    for (PagerDutyLinkConfig item : items) {PagerDutyLinkConfigBuilder builder = new PagerDutyLinkConfigBuilder(item);_visitables.get("pagerDutyLinkConfigs").remove(builder); this.pagerDutyLinkConfigs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPagerDutyLinkConfigs(Predicate<PagerDutyLinkConfigBuilder> predicate) {
    if (pagerDutyLinkConfigs == null) return (A) this;
    final Iterator<PagerDutyLinkConfigBuilder> each = pagerDutyLinkConfigs.iterator();
    final List visitables = _visitables.get("pagerDutyLinkConfigs");
    while (each.hasNext()) {
      PagerDutyLinkConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PagerDutyLinkConfig> buildPagerDutyLinkConfigs() {
    return this.pagerDutyLinkConfigs != null ? build(pagerDutyLinkConfigs) : null;
  }
  
  public PagerDutyLinkConfig buildPagerDutyLinkConfig(int index) {
    return this.pagerDutyLinkConfigs.get(index).build();
  }
  
  public PagerDutyLinkConfig buildFirstPagerDutyLinkConfig() {
    return this.pagerDutyLinkConfigs.get(0).build();
  }
  
  public PagerDutyLinkConfig buildLastPagerDutyLinkConfig() {
    return this.pagerDutyLinkConfigs.get(pagerDutyLinkConfigs.size() - 1).build();
  }
  
  public PagerDutyLinkConfig buildMatchingPagerDutyLinkConfig(Predicate<PagerDutyLinkConfigBuilder> predicate) {
      for (PagerDutyLinkConfigBuilder item : pagerDutyLinkConfigs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPagerDutyLinkConfig(Predicate<PagerDutyLinkConfigBuilder> predicate) {
      for (PagerDutyLinkConfigBuilder item : pagerDutyLinkConfigs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPagerDutyLinkConfigs(List<PagerDutyLinkConfig> pagerDutyLinkConfigs) {
    if (this.pagerDutyLinkConfigs != null) {
      this._visitables.get("pagerDutyLinkConfigs").clear();
    }
    if (pagerDutyLinkConfigs != null) {
        this.pagerDutyLinkConfigs = new ArrayList();
        for (PagerDutyLinkConfig item : pagerDutyLinkConfigs) {
          this.addToPagerDutyLinkConfigs(item);
        }
    } else {
      this.pagerDutyLinkConfigs = null;
    }
    return (A) this;
  }
  
  public A withPagerDutyLinkConfigs(io.fabric8.openshift.api.model.monitoring.v1beta1.PagerDutyLinkConfig... pagerDutyLinkConfigs) {
    if (this.pagerDutyLinkConfigs != null) {
        this.pagerDutyLinkConfigs.clear();
        _visitables.remove("pagerDutyLinkConfigs");
    }
    if (pagerDutyLinkConfigs != null) {
      for (PagerDutyLinkConfig item : pagerDutyLinkConfigs) {
        this.addToPagerDutyLinkConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPagerDutyLinkConfigs() {
    return this.pagerDutyLinkConfigs != null && !this.pagerDutyLinkConfigs.isEmpty();
  }
  
  public A addNewPagerDutyLinkConfig(String alt,String href) {
    return (A)addToPagerDutyLinkConfigs(new PagerDutyLinkConfig(alt, href));
  }
  
  public PagerDutyLinkConfigsNested<A> addNewPagerDutyLinkConfig() {
    return new PagerDutyLinkConfigsNested(-1, null);
  }
  
  public PagerDutyLinkConfigsNested<A> addNewPagerDutyLinkConfigLike(PagerDutyLinkConfig item) {
    return new PagerDutyLinkConfigsNested(-1, item);
  }
  
  public PagerDutyLinkConfigsNested<A> setNewPagerDutyLinkConfigLike(int index,PagerDutyLinkConfig item) {
    return new PagerDutyLinkConfigsNested(index, item);
  }
  
  public PagerDutyLinkConfigsNested<A> editPagerDutyLinkConfig(int index) {
    if (pagerDutyLinkConfigs.size() <= index) throw new RuntimeException("Can't edit pagerDutyLinkConfigs. Index exceeds size.");
    return setNewPagerDutyLinkConfigLike(index, buildPagerDutyLinkConfig(index));
  }
  
  public PagerDutyLinkConfigsNested<A> editFirstPagerDutyLinkConfig() {
    if (pagerDutyLinkConfigs.size() == 0) throw new RuntimeException("Can't edit first pagerDutyLinkConfigs. The list is empty.");
    return setNewPagerDutyLinkConfigLike(0, buildPagerDutyLinkConfig(0));
  }
  
  public PagerDutyLinkConfigsNested<A> editLastPagerDutyLinkConfig() {
    int index = pagerDutyLinkConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last pagerDutyLinkConfigs. The list is empty.");
    return setNewPagerDutyLinkConfigLike(index, buildPagerDutyLinkConfig(index));
  }
  
  public PagerDutyLinkConfigsNested<A> editMatchingPagerDutyLinkConfig(Predicate<PagerDutyLinkConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<pagerDutyLinkConfigs.size();i++) { 
    if (predicate.test(pagerDutyLinkConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching pagerDutyLinkConfigs. No match found.");
    return setNewPagerDutyLinkConfigLike(index, buildPagerDutyLinkConfig(index));
  }
  
  public SecretKeySelector buildRoutingKey() {
    return this.routingKey != null ? this.routingKey.build() : null;
  }
  
  public A withRoutingKey(SecretKeySelector routingKey) {
    this._visitables.remove("routingKey");
    if (routingKey != null) {
        this.routingKey = new SecretKeySelectorBuilder(routingKey);
        this._visitables.get("routingKey").add(this.routingKey);
    } else {
        this.routingKey = null;
        this._visitables.get("routingKey").remove(this.routingKey);
    }
    return (A) this;
  }
  
  public boolean hasRoutingKey() {
    return this.routingKey != null;
  }
  
  public A withNewRoutingKey(String key,String name) {
    return (A)withRoutingKey(new SecretKeySelector(key, name));
  }
  
  public RoutingKeyNested<A> withNewRoutingKey() {
    return new RoutingKeyNested(null);
  }
  
  public RoutingKeyNested<A> withNewRoutingKeyLike(SecretKeySelector item) {
    return new RoutingKeyNested(item);
  }
  
  public RoutingKeyNested<A> editRoutingKey() {
    return withNewRoutingKeyLike(java.util.Optional.ofNullable(buildRoutingKey()).orElse(null));
  }
  
  public RoutingKeyNested<A> editOrNewRoutingKey() {
    return withNewRoutingKeyLike(java.util.Optional.ofNullable(buildRoutingKey()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public RoutingKeyNested<A> editOrNewRoutingKeyLike(SecretKeySelector item) {
    return withNewRoutingKeyLike(java.util.Optional.ofNullable(buildRoutingKey()).orElse(item));
  }
  
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved = sendResolved;
    return (A) this;
  }
  
  public boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  
  public SecretKeySelector buildServiceKey() {
    return this.serviceKey != null ? this.serviceKey.build() : null;
  }
  
  public A withServiceKey(SecretKeySelector serviceKey) {
    this._visitables.remove("serviceKey");
    if (serviceKey != null) {
        this.serviceKey = new SecretKeySelectorBuilder(serviceKey);
        this._visitables.get("serviceKey").add(this.serviceKey);
    } else {
        this.serviceKey = null;
        this._visitables.get("serviceKey").remove(this.serviceKey);
    }
    return (A) this;
  }
  
  public boolean hasServiceKey() {
    return this.serviceKey != null;
  }
  
  public A withNewServiceKey(String key,String name) {
    return (A)withServiceKey(new SecretKeySelector(key, name));
  }
  
  public ServiceKeyNested<A> withNewServiceKey() {
    return new ServiceKeyNested(null);
  }
  
  public ServiceKeyNested<A> withNewServiceKeyLike(SecretKeySelector item) {
    return new ServiceKeyNested(item);
  }
  
  public ServiceKeyNested<A> editServiceKey() {
    return withNewServiceKeyLike(java.util.Optional.ofNullable(buildServiceKey()).orElse(null));
  }
  
  public ServiceKeyNested<A> editOrNewServiceKey() {
    return withNewServiceKeyLike(java.util.Optional.ofNullable(buildServiceKey()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public ServiceKeyNested<A> editOrNewServiceKeyLike(SecretKeySelector item) {
    return withNewServiceKeyLike(java.util.Optional.ofNullable(buildServiceKey()).orElse(item));
  }
  
  public String getSeverity() {
    return this.severity;
  }
  
  public A withSeverity(String severity) {
    this.severity = severity;
    return (A) this;
  }
  
  public boolean hasSeverity() {
    return this.severity != null;
  }
  
  public String getSource() {
    return this.source;
  }
  
  public A withSource(String source) {
    this.source = source;
    return (A) this;
  }
  
  public boolean hasSource() {
    return this.source != null;
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PagerDutyConfigFluent that = (PagerDutyConfigFluent) o;
    if (!java.util.Objects.equals(className, that.className)) return false;
    if (!java.util.Objects.equals(client, that.client)) return false;
    if (!java.util.Objects.equals(clientURL, that.clientURL)) return false;
    if (!java.util.Objects.equals(component, that.component)) return false;
    if (!java.util.Objects.equals(description, that.description)) return false;
    if (!java.util.Objects.equals(details, that.details)) return false;
    if (!java.util.Objects.equals(group, that.group)) return false;
    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;
    if (!java.util.Objects.equals(pagerDutyImageConfigs, that.pagerDutyImageConfigs)) return false;
    if (!java.util.Objects.equals(pagerDutyLinkConfigs, that.pagerDutyLinkConfigs)) return false;
    if (!java.util.Objects.equals(routingKey, that.routingKey)) return false;
    if (!java.util.Objects.equals(sendResolved, that.sendResolved)) return false;
    if (!java.util.Objects.equals(serviceKey, that.serviceKey)) return false;
    if (!java.util.Objects.equals(severity, that.severity)) return false;
    if (!java.util.Objects.equals(source, that.source)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(className,  client,  clientURL,  component,  description,  details,  group,  httpConfig,  pagerDutyImageConfigs,  pagerDutyLinkConfigs,  routingKey,  sendResolved,  serviceKey,  severity,  source,  url,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (className != null) { sb.append("className:"); sb.append(className + ","); }
    if (client != null) { sb.append("client:"); sb.append(client + ","); }
    if (clientURL != null) { sb.append("clientURL:"); sb.append(clientURL + ","); }
    if (component != null) { sb.append("component:"); sb.append(component + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (details != null && !details.isEmpty()) { sb.append("details:"); sb.append(details + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (pagerDutyImageConfigs != null && !pagerDutyImageConfigs.isEmpty()) { sb.append("pagerDutyImageConfigs:"); sb.append(pagerDutyImageConfigs + ","); }
    if (pagerDutyLinkConfigs != null && !pagerDutyLinkConfigs.isEmpty()) { sb.append("pagerDutyLinkConfigs:"); sb.append(pagerDutyLinkConfigs + ","); }
    if (routingKey != null) { sb.append("routingKey:"); sb.append(routingKey + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (serviceKey != null) { sb.append("serviceKey:"); sb.append(serviceKey + ","); }
    if (severity != null) { sb.append("severity:"); sb.append(severity + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSendResolved() {
    return withSendResolved(true);
  }
  public class DetailsNested<N> extends KeyValueFluent<DetailsNested<N>> implements Nested<N>{
    DetailsNested(int index,KeyValue item) {
      this.index = index;
      this.builder = new KeyValueBuilder(this, item);
    }
    KeyValueBuilder builder;
    int index;
    
    public N and() {
      return (N) PagerDutyConfigFluent.this.setToDetails(index,builder.build());
    }
    
    public N endDetail() {
      return and();
    }
    
  
  }
  public class HttpConfigNested<N> extends HTTPConfigFluent<HttpConfigNested<N>> implements Nested<N>{
    HttpConfigNested(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HTTPConfigBuilder builder;
    
    public N and() {
      return (N) PagerDutyConfigFluent.this.withHttpConfig(builder.build());
    }
    
    public N endHttpConfig() {
      return and();
    }
    
  
  }
  public class PagerDutyImageConfigsNested<N> extends PagerDutyImageConfigFluent<PagerDutyImageConfigsNested<N>> implements Nested<N>{
    PagerDutyImageConfigsNested(int index,PagerDutyImageConfig item) {
      this.index = index;
      this.builder = new PagerDutyImageConfigBuilder(this, item);
    }
    PagerDutyImageConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) PagerDutyConfigFluent.this.setToPagerDutyImageConfigs(index,builder.build());
    }
    
    public N endPagerDutyImageConfig() {
      return and();
    }
    
  
  }
  public class PagerDutyLinkConfigsNested<N> extends PagerDutyLinkConfigFluent<PagerDutyLinkConfigsNested<N>> implements Nested<N>{
    PagerDutyLinkConfigsNested(int index,PagerDutyLinkConfig item) {
      this.index = index;
      this.builder = new PagerDutyLinkConfigBuilder(this, item);
    }
    PagerDutyLinkConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) PagerDutyConfigFluent.this.setToPagerDutyLinkConfigs(index,builder.build());
    }
    
    public N endPagerDutyLinkConfig() {
      return and();
    }
    
  
  }
  public class RoutingKeyNested<N> extends SecretKeySelectorFluent<RoutingKeyNested<N>> implements Nested<N>{
    RoutingKeyNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) PagerDutyConfigFluent.this.withRoutingKey(builder.build());
    }
    
    public N endRoutingKey() {
      return and();
    }
    
  
  }
  public class ServiceKeyNested<N> extends SecretKeySelectorFluent<ServiceKeyNested<N>> implements Nested<N>{
    ServiceKeyNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) PagerDutyConfigFluent.this.withServiceKey(builder.build());
    }
    
    public N endServiceKey() {
      return and();
    }
    
  
  }

}