package io.fabric8.openshift.api.model.monitoring.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PushoverConfigFluent<A extends PushoverConfigFluent<A>> extends BaseFluent<A>{
  public PushoverConfigFluent() {
  }
  
  public PushoverConfigFluent(PushoverConfig instance) {
    this.copyInstance(instance);
  }
  private String device;
  private String expire;
  private Boolean html;
  private HTTPConfigBuilder httpConfig;
  private String message;
  private String priority;
  private String retry;
  private Boolean sendResolved;
  private String sound;
  private String title;
  private SecretKeySelectorBuilder token;
  private String tokenFile;
  private String ttl;
  private String url;
  private String urlTitle;
  private SecretKeySelectorBuilder userKey;
  private String userKeyFile;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PushoverConfig instance) {
    instance = (instance != null ? instance : new PushoverConfig());
    if (instance != null) {
          this.withDevice(instance.getDevice());
          this.withExpire(instance.getExpire());
          this.withHtml(instance.getHtml());
          this.withHttpConfig(instance.getHttpConfig());
          this.withMessage(instance.getMessage());
          this.withPriority(instance.getPriority());
          this.withRetry(instance.getRetry());
          this.withSendResolved(instance.getSendResolved());
          this.withSound(instance.getSound());
          this.withTitle(instance.getTitle());
          this.withToken(instance.getToken());
          this.withTokenFile(instance.getTokenFile());
          this.withTtl(instance.getTtl());
          this.withUrl(instance.getUrl());
          this.withUrlTitle(instance.getUrlTitle());
          this.withUserKey(instance.getUserKey());
          this.withUserKeyFile(instance.getUserKeyFile());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getDevice() {
    return this.device;
  }
  
  public A withDevice(String device) {
    this.device = device;
    return (A) this;
  }
  
  public boolean hasDevice() {
    return this.device != null;
  }
  
  public String getExpire() {
    return this.expire;
  }
  
  public A withExpire(String expire) {
    this.expire = expire;
    return (A) this;
  }
  
  public boolean hasExpire() {
    return this.expire != null;
  }
  
  public Boolean getHtml() {
    return this.html;
  }
  
  public A withHtml(Boolean html) {
    this.html = html;
    return (A) this;
  }
  
  public boolean hasHtml() {
    return this.html != null;
  }
  
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig != null ? this.httpConfig.build() : null;
  }
  
  public A withHttpConfig(HTTPConfig httpConfig) {
    this._visitables.remove("httpConfig");
    if (httpConfig != null) {
        this.httpConfig = new HTTPConfigBuilder(httpConfig);
        this._visitables.get("httpConfig").add(this.httpConfig);
    } else {
        this.httpConfig = null;
        this._visitables.get("httpConfig").remove(this.httpConfig);
    }
    return (A) this;
  }
  
  public boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  
  public HttpConfigNested<A> withNewHttpConfig() {
    return new HttpConfigNested(null);
  }
  
  public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new HttpConfigNested(item);
  }
  
  public HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(null));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(item));
  }
  
  public String getMessage() {
    return this.message;
  }
  
  public A withMessage(String message) {
    this.message = message;
    return (A) this;
  }
  
  public boolean hasMessage() {
    return this.message != null;
  }
  
  public String getPriority() {
    return this.priority;
  }
  
  public A withPriority(String priority) {
    this.priority = priority;
    return (A) this;
  }
  
  public boolean hasPriority() {
    return this.priority != null;
  }
  
  public String getRetry() {
    return this.retry;
  }
  
  public A withRetry(String retry) {
    this.retry = retry;
    return (A) this;
  }
  
  public boolean hasRetry() {
    return this.retry != null;
  }
  
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved = sendResolved;
    return (A) this;
  }
  
  public boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  
  public String getSound() {
    return this.sound;
  }
  
  public A withSound(String sound) {
    this.sound = sound;
    return (A) this;
  }
  
  public boolean hasSound() {
    return this.sound != null;
  }
  
  public String getTitle() {
    return this.title;
  }
  
  public A withTitle(String title) {
    this.title = title;
    return (A) this;
  }
  
  public boolean hasTitle() {
    return this.title != null;
  }
  
  public SecretKeySelector buildToken() {
    return this.token != null ? this.token.build() : null;
  }
  
  public A withToken(SecretKeySelector token) {
    this._visitables.remove("token");
    if (token != null) {
        this.token = new SecretKeySelectorBuilder(token);
        this._visitables.get("token").add(this.token);
    } else {
        this.token = null;
        this._visitables.get("token").remove(this.token);
    }
    return (A) this;
  }
  
  public boolean hasToken() {
    return this.token != null;
  }
  
  public A withNewToken(String key,String name) {
    return (A)withToken(new SecretKeySelector(key, name));
  }
  
  public TokenNested<A> withNewToken() {
    return new TokenNested(null);
  }
  
  public TokenNested<A> withNewTokenLike(SecretKeySelector item) {
    return new TokenNested(item);
  }
  
  public TokenNested<A> editToken() {
    return withNewTokenLike(java.util.Optional.ofNullable(buildToken()).orElse(null));
  }
  
  public TokenNested<A> editOrNewToken() {
    return withNewTokenLike(java.util.Optional.ofNullable(buildToken()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public TokenNested<A> editOrNewTokenLike(SecretKeySelector item) {
    return withNewTokenLike(java.util.Optional.ofNullable(buildToken()).orElse(item));
  }
  
  public String getTokenFile() {
    return this.tokenFile;
  }
  
  public A withTokenFile(String tokenFile) {
    this.tokenFile = tokenFile;
    return (A) this;
  }
  
  public boolean hasTokenFile() {
    return this.tokenFile != null;
  }
  
  public String getTtl() {
    return this.ttl;
  }
  
  public A withTtl(String ttl) {
    this.ttl = ttl;
    return (A) this;
  }
  
  public boolean hasTtl() {
    return this.ttl != null;
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public String getUrlTitle() {
    return this.urlTitle;
  }
  
  public A withUrlTitle(String urlTitle) {
    this.urlTitle = urlTitle;
    return (A) this;
  }
  
  public boolean hasUrlTitle() {
    return this.urlTitle != null;
  }
  
  public SecretKeySelector buildUserKey() {
    return this.userKey != null ? this.userKey.build() : null;
  }
  
  public A withUserKey(SecretKeySelector userKey) {
    this._visitables.remove("userKey");
    if (userKey != null) {
        this.userKey = new SecretKeySelectorBuilder(userKey);
        this._visitables.get("userKey").add(this.userKey);
    } else {
        this.userKey = null;
        this._visitables.get("userKey").remove(this.userKey);
    }
    return (A) this;
  }
  
  public boolean hasUserKey() {
    return this.userKey != null;
  }
  
  public A withNewUserKey(String key,String name) {
    return (A)withUserKey(new SecretKeySelector(key, name));
  }
  
  public UserKeyNested<A> withNewUserKey() {
    return new UserKeyNested(null);
  }
  
  public UserKeyNested<A> withNewUserKeyLike(SecretKeySelector item) {
    return new UserKeyNested(item);
  }
  
  public UserKeyNested<A> editUserKey() {
    return withNewUserKeyLike(java.util.Optional.ofNullable(buildUserKey()).orElse(null));
  }
  
  public UserKeyNested<A> editOrNewUserKey() {
    return withNewUserKeyLike(java.util.Optional.ofNullable(buildUserKey()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public UserKeyNested<A> editOrNewUserKeyLike(SecretKeySelector item) {
    return withNewUserKeyLike(java.util.Optional.ofNullable(buildUserKey()).orElse(item));
  }
  
  public String getUserKeyFile() {
    return this.userKeyFile;
  }
  
  public A withUserKeyFile(String userKeyFile) {
    this.userKeyFile = userKeyFile;
    return (A) this;
  }
  
  public boolean hasUserKeyFile() {
    return this.userKeyFile != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PushoverConfigFluent that = (PushoverConfigFluent) o;
    if (!java.util.Objects.equals(device, that.device)) return false;
    if (!java.util.Objects.equals(expire, that.expire)) return false;
    if (!java.util.Objects.equals(html, that.html)) return false;
    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;
    if (!java.util.Objects.equals(message, that.message)) return false;
    if (!java.util.Objects.equals(priority, that.priority)) return false;
    if (!java.util.Objects.equals(retry, that.retry)) return false;
    if (!java.util.Objects.equals(sendResolved, that.sendResolved)) return false;
    if (!java.util.Objects.equals(sound, that.sound)) return false;
    if (!java.util.Objects.equals(title, that.title)) return false;
    if (!java.util.Objects.equals(token, that.token)) return false;
    if (!java.util.Objects.equals(tokenFile, that.tokenFile)) return false;
    if (!java.util.Objects.equals(ttl, that.ttl)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(urlTitle, that.urlTitle)) return false;
    if (!java.util.Objects.equals(userKey, that.userKey)) return false;
    if (!java.util.Objects.equals(userKeyFile, that.userKeyFile)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(device,  expire,  html,  httpConfig,  message,  priority,  retry,  sendResolved,  sound,  title,  token,  tokenFile,  ttl,  url,  urlTitle,  userKey,  userKeyFile,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (device != null) { sb.append("device:"); sb.append(device + ","); }
    if (expire != null) { sb.append("expire:"); sb.append(expire + ","); }
    if (html != null) { sb.append("html:"); sb.append(html + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (retry != null) { sb.append("retry:"); sb.append(retry + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (sound != null) { sb.append("sound:"); sb.append(sound + ","); }
    if (title != null) { sb.append("title:"); sb.append(title + ","); }
    if (token != null) { sb.append("token:"); sb.append(token + ","); }
    if (tokenFile != null) { sb.append("tokenFile:"); sb.append(tokenFile + ","); }
    if (ttl != null) { sb.append("ttl:"); sb.append(ttl + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (urlTitle != null) { sb.append("urlTitle:"); sb.append(urlTitle + ","); }
    if (userKey != null) { sb.append("userKey:"); sb.append(userKey + ","); }
    if (userKeyFile != null) { sb.append("userKeyFile:"); sb.append(userKeyFile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withHtml() {
    return withHtml(true);
  }
  
  public A withSendResolved() {
    return withSendResolved(true);
  }
  public class HttpConfigNested<N> extends HTTPConfigFluent<HttpConfigNested<N>> implements Nested<N>{
    HttpConfigNested(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HTTPConfigBuilder builder;
    
    public N and() {
      return (N) PushoverConfigFluent.this.withHttpConfig(builder.build());
    }
    
    public N endHttpConfig() {
      return and();
    }
    
  
  }
  public class TokenNested<N> extends SecretKeySelectorFluent<TokenNested<N>> implements Nested<N>{
    TokenNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) PushoverConfigFluent.this.withToken(builder.build());
    }
    
    public N endToken() {
      return and();
    }
    
  
  }
  public class UserKeyNested<N> extends SecretKeySelectorFluent<UserKeyNested<N>> implements Nested<N>{
    UserKeyNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) PushoverConfigFluent.this.withUserKey(builder.build());
    }
    
    public N endUserKey() {
      return and();
    }
    
  
  }

}