package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RouteFluent<A extends RouteFluent<A>> extends BaseFluent<A>{
  public RouteFluent() {
  }
  
  public RouteFluent(Route instance) {
    this.copyInstance(instance);
  }
  private List<String> activeTimeIntervals = new ArrayList<String>();
  private Boolean _continue;
  private List<String> groupBy = new ArrayList<String>();
  private String groupInterval;
  private String groupWait;
  private ArrayList<MatcherBuilder> matchers = new ArrayList<MatcherBuilder>();
  private List<String> muteTimeIntervals = new ArrayList<String>();
  private String receiver;
  private String repeatInterval;
  private List<JsonNode> routes = new ArrayList<JsonNode>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Route instance) {
    instance = (instance != null ? instance : new Route());
    if (instance != null) {
          this.withActiveTimeIntervals(instance.getActiveTimeIntervals());
          this.withContinue(instance.getContinue());
          this.withGroupBy(instance.getGroupBy());
          this.withGroupInterval(instance.getGroupInterval());
          this.withGroupWait(instance.getGroupWait());
          this.withMatchers(instance.getMatchers());
          this.withMuteTimeIntervals(instance.getMuteTimeIntervals());
          this.withReceiver(instance.getReceiver());
          this.withRepeatInterval(instance.getRepeatInterval());
          this.withRoutes(instance.getRoutes());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToActiveTimeIntervals(int index,String item) {
    if (this.activeTimeIntervals == null) {this.activeTimeIntervals = new ArrayList<String>();}
    this.activeTimeIntervals.add(index, item);
    return (A)this;
  }
  
  public A setToActiveTimeIntervals(int index,String item) {
    if (this.activeTimeIntervals == null) {this.activeTimeIntervals = new ArrayList<String>();}
    this.activeTimeIntervals.set(index, item); return (A)this;
  }
  
  public A addToActiveTimeIntervals(java.lang.String... items) {
    if (this.activeTimeIntervals == null) {this.activeTimeIntervals = new ArrayList<String>();}
    for (String item : items) {this.activeTimeIntervals.add(item);} return (A)this;
  }
  
  public A addAllToActiveTimeIntervals(Collection<String> items) {
    if (this.activeTimeIntervals == null) {this.activeTimeIntervals = new ArrayList<String>();}
    for (String item : items) {this.activeTimeIntervals.add(item);} return (A)this;
  }
  
  public A removeFromActiveTimeIntervals(java.lang.String... items) {
    if (this.activeTimeIntervals == null) return (A)this;
    for (String item : items) { this.activeTimeIntervals.remove(item);} return (A)this;
  }
  
  public A removeAllFromActiveTimeIntervals(Collection<String> items) {
    if (this.activeTimeIntervals == null) return (A)this;
    for (String item : items) { this.activeTimeIntervals.remove(item);} return (A)this;
  }
  
  public List<String> getActiveTimeIntervals() {
    return this.activeTimeIntervals;
  }
  
  public String getActiveTimeInterval(int index) {
    return this.activeTimeIntervals.get(index);
  }
  
  public String getFirstActiveTimeInterval() {
    return this.activeTimeIntervals.get(0);
  }
  
  public String getLastActiveTimeInterval() {
    return this.activeTimeIntervals.get(activeTimeIntervals.size() - 1);
  }
  
  public String getMatchingActiveTimeInterval(Predicate<String> predicate) {
      for (String item : activeTimeIntervals) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingActiveTimeInterval(Predicate<String> predicate) {
      for (String item : activeTimeIntervals) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withActiveTimeIntervals(List<String> activeTimeIntervals) {
    if (activeTimeIntervals != null) {
        this.activeTimeIntervals = new ArrayList();
        for (String item : activeTimeIntervals) {
          this.addToActiveTimeIntervals(item);
        }
    } else {
      this.activeTimeIntervals = null;
    }
    return (A) this;
  }
  
  public A withActiveTimeIntervals(java.lang.String... activeTimeIntervals) {
    if (this.activeTimeIntervals != null) {
        this.activeTimeIntervals.clear();
        _visitables.remove("activeTimeIntervals");
    }
    if (activeTimeIntervals != null) {
      for (String item : activeTimeIntervals) {
        this.addToActiveTimeIntervals(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasActiveTimeIntervals() {
    return this.activeTimeIntervals != null && !this.activeTimeIntervals.isEmpty();
  }
  
  public Boolean getContinue() {
    return this._continue;
  }
  
  public A withContinue(Boolean _continue) {
    this._continue = _continue;
    return (A) this;
  }
  
  public boolean hasContinue() {
    return this._continue != null;
  }
  
  public A addToGroupBy(int index,String item) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    this.groupBy.add(index, item);
    return (A)this;
  }
  
  public A setToGroupBy(int index,String item) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    this.groupBy.set(index, item); return (A)this;
  }
  
  public A addToGroupBy(java.lang.String... items) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    for (String item : items) {this.groupBy.add(item);} return (A)this;
  }
  
  public A addAllToGroupBy(Collection<String> items) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    for (String item : items) {this.groupBy.add(item);} return (A)this;
  }
  
  public A removeFromGroupBy(java.lang.String... items) {
    if (this.groupBy == null) return (A)this;
    for (String item : items) { this.groupBy.remove(item);} return (A)this;
  }
  
  public A removeAllFromGroupBy(Collection<String> items) {
    if (this.groupBy == null) return (A)this;
    for (String item : items) { this.groupBy.remove(item);} return (A)this;
  }
  
  public List<String> getGroupBy() {
    return this.groupBy;
  }
  
  public String getGroupBy(int index) {
    return this.groupBy.get(index);
  }
  
  public String getFirstGroupBy() {
    return this.groupBy.get(0);
  }
  
  public String getLastGroupBy() {
    return this.groupBy.get(groupBy.size() - 1);
  }
  
  public String getMatchingGroupBy(Predicate<String> predicate) {
      for (String item : groupBy) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingGroupBy(Predicate<String> predicate) {
      for (String item : groupBy) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGroupBy(List<String> groupBy) {
    if (groupBy != null) {
        this.groupBy = new ArrayList();
        for (String item : groupBy) {
          this.addToGroupBy(item);
        }
    } else {
      this.groupBy = null;
    }
    return (A) this;
  }
  
  public A withGroupBy(java.lang.String... groupBy) {
    if (this.groupBy != null) {
        this.groupBy.clear();
        _visitables.remove("groupBy");
    }
    if (groupBy != null) {
      for (String item : groupBy) {
        this.addToGroupBy(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGroupBy() {
    return this.groupBy != null && !this.groupBy.isEmpty();
  }
  
  public String getGroupInterval() {
    return this.groupInterval;
  }
  
  public A withGroupInterval(String groupInterval) {
    this.groupInterval = groupInterval;
    return (A) this;
  }
  
  public boolean hasGroupInterval() {
    return this.groupInterval != null;
  }
  
  public String getGroupWait() {
    return this.groupWait;
  }
  
  public A withGroupWait(String groupWait) {
    this.groupWait = groupWait;
    return (A) this;
  }
  
  public boolean hasGroupWait() {
    return this.groupWait != null;
  }
  
  public A addToMatchers(int index,Matcher item) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);
    if (index < 0 || index >= matchers.size()) {
        _visitables.get("matchers").add(builder);
        matchers.add(builder);
    } else {
        _visitables.get("matchers").add(builder);
        matchers.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToMatchers(int index,Matcher item) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);
    if (index < 0 || index >= matchers.size()) {
        _visitables.get("matchers").add(builder);
        matchers.add(builder);
    } else {
        _visitables.get("matchers").add(builder);
        matchers.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToMatchers(io.fabric8.openshift.api.model.monitoring.v1beta1.Matcher... items) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").add(builder);this.matchers.add(builder);} return (A)this;
  }
  
  public A addAllToMatchers(Collection<Matcher> items) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").add(builder);this.matchers.add(builder);} return (A)this;
  }
  
  public A removeFromMatchers(io.fabric8.openshift.api.model.monitoring.v1beta1.Matcher... items) {
    if (this.matchers == null) return (A)this;
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").remove(builder); this.matchers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMatchers(Collection<Matcher> items) {
    if (this.matchers == null) return (A)this;
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").remove(builder); this.matchers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMatchers(Predicate<MatcherBuilder> predicate) {
    if (matchers == null) return (A) this;
    final Iterator<MatcherBuilder> each = matchers.iterator();
    final List visitables = _visitables.get("matchers");
    while (each.hasNext()) {
      MatcherBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Matcher> buildMatchers() {
    return this.matchers != null ? build(matchers) : null;
  }
  
  public Matcher buildMatcher(int index) {
    return this.matchers.get(index).build();
  }
  
  public Matcher buildFirstMatcher() {
    return this.matchers.get(0).build();
  }
  
  public Matcher buildLastMatcher() {
    return this.matchers.get(matchers.size() - 1).build();
  }
  
  public Matcher buildMatchingMatcher(Predicate<MatcherBuilder> predicate) {
      for (MatcherBuilder item : matchers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMatcher(Predicate<MatcherBuilder> predicate) {
      for (MatcherBuilder item : matchers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMatchers(List<Matcher> matchers) {
    if (this.matchers != null) {
      this._visitables.get("matchers").clear();
    }
    if (matchers != null) {
        this.matchers = new ArrayList();
        for (Matcher item : matchers) {
          this.addToMatchers(item);
        }
    } else {
      this.matchers = null;
    }
    return (A) this;
  }
  
  public A withMatchers(io.fabric8.openshift.api.model.monitoring.v1beta1.Matcher... matchers) {
    if (this.matchers != null) {
        this.matchers.clear();
        _visitables.remove("matchers");
    }
    if (matchers != null) {
      for (Matcher item : matchers) {
        this.addToMatchers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMatchers() {
    return this.matchers != null && !this.matchers.isEmpty();
  }
  
  public A addNewMatcher(String matchType,String name,String value) {
    return (A)addToMatchers(new Matcher(matchType, name, value));
  }
  
  public MatchersNested<A> addNewMatcher() {
    return new MatchersNested(-1, null);
  }
  
  public MatchersNested<A> addNewMatcherLike(Matcher item) {
    return new MatchersNested(-1, item);
  }
  
  public MatchersNested<A> setNewMatcherLike(int index,Matcher item) {
    return new MatchersNested(index, item);
  }
  
  public MatchersNested<A> editMatcher(int index) {
    if (matchers.size() <= index) throw new RuntimeException("Can't edit matchers. Index exceeds size.");
    return setNewMatcherLike(index, buildMatcher(index));
  }
  
  public MatchersNested<A> editFirstMatcher() {
    if (matchers.size() == 0) throw new RuntimeException("Can't edit first matchers. The list is empty.");
    return setNewMatcherLike(0, buildMatcher(0));
  }
  
  public MatchersNested<A> editLastMatcher() {
    int index = matchers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchers. The list is empty.");
    return setNewMatcherLike(index, buildMatcher(index));
  }
  
  public MatchersNested<A> editMatchingMatcher(Predicate<MatcherBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchers.size();i++) { 
    if (predicate.test(matchers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchers. No match found.");
    return setNewMatcherLike(index, buildMatcher(index));
  }
  
  public A addToMuteTimeIntervals(int index,String item) {
    if (this.muteTimeIntervals == null) {this.muteTimeIntervals = new ArrayList<String>();}
    this.muteTimeIntervals.add(index, item);
    return (A)this;
  }
  
  public A setToMuteTimeIntervals(int index,String item) {
    if (this.muteTimeIntervals == null) {this.muteTimeIntervals = new ArrayList<String>();}
    this.muteTimeIntervals.set(index, item); return (A)this;
  }
  
  public A addToMuteTimeIntervals(java.lang.String... items) {
    if (this.muteTimeIntervals == null) {this.muteTimeIntervals = new ArrayList<String>();}
    for (String item : items) {this.muteTimeIntervals.add(item);} return (A)this;
  }
  
  public A addAllToMuteTimeIntervals(Collection<String> items) {
    if (this.muteTimeIntervals == null) {this.muteTimeIntervals = new ArrayList<String>();}
    for (String item : items) {this.muteTimeIntervals.add(item);} return (A)this;
  }
  
  public A removeFromMuteTimeIntervals(java.lang.String... items) {
    if (this.muteTimeIntervals == null) return (A)this;
    for (String item : items) { this.muteTimeIntervals.remove(item);} return (A)this;
  }
  
  public A removeAllFromMuteTimeIntervals(Collection<String> items) {
    if (this.muteTimeIntervals == null) return (A)this;
    for (String item : items) { this.muteTimeIntervals.remove(item);} return (A)this;
  }
  
  public List<String> getMuteTimeIntervals() {
    return this.muteTimeIntervals;
  }
  
  public String getMuteTimeInterval(int index) {
    return this.muteTimeIntervals.get(index);
  }
  
  public String getFirstMuteTimeInterval() {
    return this.muteTimeIntervals.get(0);
  }
  
  public String getLastMuteTimeInterval() {
    return this.muteTimeIntervals.get(muteTimeIntervals.size() - 1);
  }
  
  public String getMatchingMuteTimeInterval(Predicate<String> predicate) {
      for (String item : muteTimeIntervals) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingMuteTimeInterval(Predicate<String> predicate) {
      for (String item : muteTimeIntervals) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMuteTimeIntervals(List<String> muteTimeIntervals) {
    if (muteTimeIntervals != null) {
        this.muteTimeIntervals = new ArrayList();
        for (String item : muteTimeIntervals) {
          this.addToMuteTimeIntervals(item);
        }
    } else {
      this.muteTimeIntervals = null;
    }
    return (A) this;
  }
  
  public A withMuteTimeIntervals(java.lang.String... muteTimeIntervals) {
    if (this.muteTimeIntervals != null) {
        this.muteTimeIntervals.clear();
        _visitables.remove("muteTimeIntervals");
    }
    if (muteTimeIntervals != null) {
      for (String item : muteTimeIntervals) {
        this.addToMuteTimeIntervals(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMuteTimeIntervals() {
    return this.muteTimeIntervals != null && !this.muteTimeIntervals.isEmpty();
  }
  
  public String getReceiver() {
    return this.receiver;
  }
  
  public A withReceiver(String receiver) {
    this.receiver = receiver;
    return (A) this;
  }
  
  public boolean hasReceiver() {
    return this.receiver != null;
  }
  
  public String getRepeatInterval() {
    return this.repeatInterval;
  }
  
  public A withRepeatInterval(String repeatInterval) {
    this.repeatInterval = repeatInterval;
    return (A) this;
  }
  
  public boolean hasRepeatInterval() {
    return this.repeatInterval != null;
  }
  
  public A addToRoutes(int index,JsonNode item) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    this.routes.add(index, item);
    return (A)this;
  }
  
  public A setToRoutes(int index,JsonNode item) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    this.routes.set(index, item); return (A)this;
  }
  
  public A addToRoutes(com.fasterxml.jackson.databind.JsonNode... items) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this.routes.add(item);} return (A)this;
  }
  
  public A addAllToRoutes(Collection<JsonNode> items) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this.routes.add(item);} return (A)this;
  }
  
  public A removeFromRoutes(com.fasterxml.jackson.databind.JsonNode... items) {
    if (this.routes == null) return (A)this;
    for (JsonNode item : items) { this.routes.remove(item);} return (A)this;
  }
  
  public A removeAllFromRoutes(Collection<JsonNode> items) {
    if (this.routes == null) return (A)this;
    for (JsonNode item : items) { this.routes.remove(item);} return (A)this;
  }
  
  public List<JsonNode> getRoutes() {
    return this.routes;
  }
  
  public JsonNode getRoute(int index) {
    return this.routes.get(index);
  }
  
  public JsonNode getFirstRoute() {
    return this.routes.get(0);
  }
  
  public JsonNode getLastRoute() {
    return this.routes.get(routes.size() - 1);
  }
  
  public JsonNode getMatchingRoute(Predicate<JsonNode> predicate) {
      for (JsonNode item : routes) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingRoute(Predicate<JsonNode> predicate) {
      for (JsonNode item : routes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRoutes(List<JsonNode> routes) {
    if (routes != null) {
        this.routes = new ArrayList();
        for (JsonNode item : routes) {
          this.addToRoutes(item);
        }
    } else {
      this.routes = null;
    }
    return (A) this;
  }
  
  public A withRoutes(com.fasterxml.jackson.databind.JsonNode... routes) {
    if (this.routes != null) {
        this.routes.clear();
        _visitables.remove("routes");
    }
    if (routes != null) {
      for (JsonNode item : routes) {
        this.addToRoutes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRoutes() {
    return this.routes != null && !this.routes.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RouteFluent that = (RouteFluent) o;
    if (!java.util.Objects.equals(activeTimeIntervals, that.activeTimeIntervals)) return false;
    if (!java.util.Objects.equals(_continue, that._continue)) return false;
    if (!java.util.Objects.equals(groupBy, that.groupBy)) return false;
    if (!java.util.Objects.equals(groupInterval, that.groupInterval)) return false;
    if (!java.util.Objects.equals(groupWait, that.groupWait)) return false;
    if (!java.util.Objects.equals(matchers, that.matchers)) return false;
    if (!java.util.Objects.equals(muteTimeIntervals, that.muteTimeIntervals)) return false;
    if (!java.util.Objects.equals(receiver, that.receiver)) return false;
    if (!java.util.Objects.equals(repeatInterval, that.repeatInterval)) return false;
    if (!java.util.Objects.equals(routes, that.routes)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(activeTimeIntervals,  _continue,  groupBy,  groupInterval,  groupWait,  matchers,  muteTimeIntervals,  receiver,  repeatInterval,  routes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (activeTimeIntervals != null && !activeTimeIntervals.isEmpty()) { sb.append("activeTimeIntervals:"); sb.append(activeTimeIntervals + ","); }
    if (_continue != null) { sb.append("_continue:"); sb.append(_continue + ","); }
    if (groupBy != null && !groupBy.isEmpty()) { sb.append("groupBy:"); sb.append(groupBy + ","); }
    if (groupInterval != null) { sb.append("groupInterval:"); sb.append(groupInterval + ","); }
    if (groupWait != null) { sb.append("groupWait:"); sb.append(groupWait + ","); }
    if (matchers != null && !matchers.isEmpty()) { sb.append("matchers:"); sb.append(matchers + ","); }
    if (muteTimeIntervals != null && !muteTimeIntervals.isEmpty()) { sb.append("muteTimeIntervals:"); sb.append(muteTimeIntervals + ","); }
    if (receiver != null) { sb.append("receiver:"); sb.append(receiver + ","); }
    if (repeatInterval != null) { sb.append("repeatInterval:"); sb.append(repeatInterval + ","); }
    if (routes != null && !routes.isEmpty()) { sb.append("routes:"); sb.append(routes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withContinue() {
    return withContinue(true);
  }
  public class MatchersNested<N> extends MatcherFluent<MatchersNested<N>> implements Nested<N>{
    MatchersNested(int index,Matcher item) {
      this.index = index;
      this.builder = new MatcherBuilder(this, item);
    }
    MatcherBuilder builder;
    int index;
    
    public N and() {
      return (N) RouteFluent.this.setToMatchers(index,builder.build());
    }
    
    public N endMatcher() {
      return and();
    }
    
  
  }

}