/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.AttachMetadata;
import io.fabric8.openshift.api.model.monitoring.v1.AttachMetadataBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AttachMetadataFluent;
import io.fabric8.openshift.api.model.monitoring.v1.Authorization;
import io.fabric8.openshift.api.model.monitoring.v1.AuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.ScrapeClass;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ScrapeClassFluent<A extends ScrapeClassFluent<A>>
extends BaseFluent<A> {
    private AttachMetadataBuilder attachMetadata;
    private AuthorizationBuilder authorization;
    private Boolean _default;
    private String fallbackScrapeProtocol;
    private ArrayList<RelabelConfigBuilder> metricRelabelings = new ArrayList();
    private String name;
    private ArrayList<RelabelConfigBuilder> relabelings = new ArrayList();
    private TLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public ScrapeClassFluent() {
    }

    public ScrapeClassFluent(ScrapeClass instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ScrapeClass instance) {
        ScrapeClass scrapeClass = instance = instance != null ? instance : new ScrapeClass();
        if (instance != null) {
            this.withAttachMetadata(instance.getAttachMetadata());
            this.withAuthorization(instance.getAuthorization());
            this.withDefault(instance.getDefault());
            this.withFallbackScrapeProtocol(instance.getFallbackScrapeProtocol());
            this.withMetricRelabelings(instance.getMetricRelabelings());
            this.withName(instance.getName());
            this.withRelabelings(instance.getRelabelings());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AttachMetadata buildAttachMetadata() {
        return this.attachMetadata != null ? this.attachMetadata.build() : null;
    }

    public A withAttachMetadata(AttachMetadata attachMetadata) {
        this._visitables.remove((Object)"attachMetadata");
        if (attachMetadata != null) {
            this.attachMetadata = new AttachMetadataBuilder(attachMetadata);
            this._visitables.get((Object)"attachMetadata").add(this.attachMetadata);
        } else {
            this.attachMetadata = null;
            this._visitables.get((Object)"attachMetadata").remove((Object)this.attachMetadata);
        }
        return (A)((Object)this);
    }

    public boolean hasAttachMetadata() {
        return this.attachMetadata != null;
    }

    public A withNewAttachMetadata(Boolean node) {
        return this.withAttachMetadata(new AttachMetadata(node));
    }

    public AttachMetadataNested<A> withNewAttachMetadata() {
        return new AttachMetadataNested(null);
    }

    public AttachMetadataNested<A> withNewAttachMetadataLike(AttachMetadata item) {
        return new AttachMetadataNested(item);
    }

    public AttachMetadataNested<A> editAttachMetadata() {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(null));
    }

    public AttachMetadataNested<A> editOrNewAttachMetadata() {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(new AttachMetadataBuilder().build()));
    }

    public AttachMetadataNested<A> editOrNewAttachMetadataLike(AttachMetadata item) {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(item));
    }

    public Authorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(Authorization authorization) {
        this._visitables.remove((Object)"authorization");
        if (authorization != null) {
            this.authorization = new AuthorizationBuilder(authorization);
            this._visitables.get((Object)"authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get((Object)"authorization").remove((Object)this.authorization);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new AuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public Boolean getDefault() {
        return this._default;
    }

    public A withDefault(Boolean _default) {
        this._default = _default;
        return (A)((Object)this);
    }

    public boolean hasDefault() {
        return this._default != null;
    }

    public String getFallbackScrapeProtocol() {
        return this.fallbackScrapeProtocol;
    }

    public A withFallbackScrapeProtocol(String fallbackScrapeProtocol) {
        this.fallbackScrapeProtocol = fallbackScrapeProtocol;
        return (A)((Object)this);
    }

    public boolean hasFallbackScrapeProtocol() {
        return this.fallbackScrapeProtocol != null;
    }

    public A addToMetricRelabelings(int index, RelabelConfig item) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.metricRelabelings.size()) {
            this._visitables.get((Object)"metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        } else {
            this._visitables.get((Object)"metricRelabelings").add(builder);
            this.metricRelabelings.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMetricRelabelings(int index, RelabelConfig item) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.metricRelabelings.size()) {
            this._visitables.get((Object)"metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        } else {
            this._visitables.get((Object)"metricRelabelings").add(builder);
            this.metricRelabelings.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMetricRelabelings(RelabelConfig ... items) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMetricRelabelings(Collection<RelabelConfig> items) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMetricRelabelings(RelabelConfig ... items) {
        if (this.metricRelabelings == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"metricRelabelings").remove((Object)builder);
            this.metricRelabelings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMetricRelabelings(Collection<RelabelConfig> items) {
        if (this.metricRelabelings == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"metricRelabelings").remove((Object)builder);
            this.metricRelabelings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMetricRelabelings(Predicate<RelabelConfigBuilder> predicate) {
        if (this.metricRelabelings == null) {
            return (A)((Object)this);
        }
        Iterator<RelabelConfigBuilder> each = this.metricRelabelings.iterator();
        List visitables = this._visitables.get((Object)"metricRelabelings");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RelabelConfig> buildMetricRelabelings() {
        return this.metricRelabelings != null ? ScrapeClassFluent.build(this.metricRelabelings) : null;
    }

    public RelabelConfig buildMetricRelabeling(int index) {
        return this.metricRelabelings.get(index).build();
    }

    public RelabelConfig buildFirstMetricRelabeling() {
        return this.metricRelabelings.get(0).build();
    }

    public RelabelConfig buildLastMetricRelabeling() {
        return this.metricRelabelings.get(this.metricRelabelings.size() - 1).build();
    }

    public RelabelConfig buildMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.metricRelabelings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.metricRelabelings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMetricRelabelings(List<RelabelConfig> metricRelabelings) {
        if (this.metricRelabelings != null) {
            this._visitables.get((Object)"metricRelabelings").clear();
        }
        if (metricRelabelings != null) {
            this.metricRelabelings = new ArrayList();
            for (RelabelConfig item : metricRelabelings) {
                this.addToMetricRelabelings(item);
            }
        } else {
            this.metricRelabelings = null;
        }
        return (A)((Object)this);
    }

    public A withMetricRelabelings(RelabelConfig ... metricRelabelings) {
        if (this.metricRelabelings != null) {
            this.metricRelabelings.clear();
            this._visitables.remove((Object)"metricRelabelings");
        }
        if (metricRelabelings != null) {
            for (RelabelConfig item : metricRelabelings) {
                this.addToMetricRelabelings(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMetricRelabelings() {
        return this.metricRelabelings != null && !this.metricRelabelings.isEmpty();
    }

    public MetricRelabelingsNested<A> addNewMetricRelabeling() {
        return new MetricRelabelingsNested(-1, null);
    }

    public MetricRelabelingsNested<A> addNewMetricRelabelingLike(RelabelConfig item) {
        return new MetricRelabelingsNested(-1, item);
    }

    public MetricRelabelingsNested<A> setNewMetricRelabelingLike(int index, RelabelConfig item) {
        return new MetricRelabelingsNested(index, item);
    }

    public MetricRelabelingsNested<A> editMetricRelabeling(int index) {
        if (this.metricRelabelings.size() <= index) {
            throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    public MetricRelabelingsNested<A> editFirstMetricRelabeling() {
        if (this.metricRelabelings.size() == 0) {
            throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
        }
        return this.setNewMetricRelabelingLike(0, this.buildMetricRelabeling(0));
    }

    public MetricRelabelingsNested<A> editLastMetricRelabeling() {
        int index = this.metricRelabelings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    public MetricRelabelingsNested<A> editMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.metricRelabelings.size(); ++i) {
            if (!predicate.test(this.metricRelabelings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToRelabelings(int index, RelabelConfig item) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.relabelings.size()) {
            this._visitables.get((Object)"relabelings").add(builder);
            this.relabelings.add(builder);
        } else {
            this._visitables.get((Object)"relabelings").add(builder);
            this.relabelings.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRelabelings(int index, RelabelConfig item) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.relabelings.size()) {
            this._visitables.get((Object)"relabelings").add(builder);
            this.relabelings.add(builder);
        } else {
            this._visitables.get((Object)"relabelings").add(builder);
            this.relabelings.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRelabelings(RelabelConfig ... items) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelings").add(builder);
            this.relabelings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRelabelings(Collection<RelabelConfig> items) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelings").add(builder);
            this.relabelings.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRelabelings(RelabelConfig ... items) {
        if (this.relabelings == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelings").remove((Object)builder);
            this.relabelings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRelabelings(Collection<RelabelConfig> items) {
        if (this.relabelings == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelings").remove((Object)builder);
            this.relabelings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRelabelings(Predicate<RelabelConfigBuilder> predicate) {
        if (this.relabelings == null) {
            return (A)((Object)this);
        }
        Iterator<RelabelConfigBuilder> each = this.relabelings.iterator();
        List visitables = this._visitables.get((Object)"relabelings");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RelabelConfig> buildRelabelings() {
        return this.relabelings != null ? ScrapeClassFluent.build(this.relabelings) : null;
    }

    public RelabelConfig buildRelabeling(int index) {
        return this.relabelings.get(index).build();
    }

    public RelabelConfig buildFirstRelabeling() {
        return this.relabelings.get(0).build();
    }

    public RelabelConfig buildLastRelabeling() {
        return this.relabelings.get(this.relabelings.size() - 1).build();
    }

    public RelabelConfig buildMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRelabelings(List<RelabelConfig> relabelings) {
        if (this.relabelings != null) {
            this._visitables.get((Object)"relabelings").clear();
        }
        if (relabelings != null) {
            this.relabelings = new ArrayList();
            for (RelabelConfig item : relabelings) {
                this.addToRelabelings(item);
            }
        } else {
            this.relabelings = null;
        }
        return (A)((Object)this);
    }

    public A withRelabelings(RelabelConfig ... relabelings) {
        if (this.relabelings != null) {
            this.relabelings.clear();
            this._visitables.remove((Object)"relabelings");
        }
        if (relabelings != null) {
            for (RelabelConfig item : relabelings) {
                this.addToRelabelings(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRelabelings() {
        return this.relabelings != null && !this.relabelings.isEmpty();
    }

    public RelabelingsNested<A> addNewRelabeling() {
        return new RelabelingsNested(-1, null);
    }

    public RelabelingsNested<A> addNewRelabelingLike(RelabelConfig item) {
        return new RelabelingsNested(-1, item);
    }

    public RelabelingsNested<A> setNewRelabelingLike(int index, RelabelConfig item) {
        return new RelabelingsNested(index, item);
    }

    public RelabelingsNested<A> editRelabeling(int index) {
        if (this.relabelings.size() <= index) {
            throw new RuntimeException("Can't edit relabelings. Index exceeds size.");
        }
        return this.setNewRelabelingLike(index, this.buildRelabeling(index));
    }

    public RelabelingsNested<A> editFirstRelabeling() {
        if (this.relabelings.size() == 0) {
            throw new RuntimeException("Can't edit first relabelings. The list is empty.");
        }
        return this.setNewRelabelingLike(0, this.buildRelabeling(0));
    }

    public RelabelingsNested<A> editLastRelabeling() {
        int index = this.relabelings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last relabelings. The list is empty.");
        }
        return this.setNewRelabelingLike(index, this.buildRelabeling(index));
    }

    public RelabelingsNested<A> editMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relabelings.size(); ++i) {
            if (!predicate.test(this.relabelings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching relabelings. No match found.");
        }
        return this.setNewRelabelingLike(index, this.buildRelabeling(index));
    }

    public TLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(TLSConfig tlsConfig) {
        this._visitables.remove((Object)"tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new TLSConfigBuilder(tlsConfig);
            this._visitables.get((Object)"tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get((Object)"tlsConfig").remove((Object)this.tlsConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScrapeClassFluent that = (ScrapeClassFluent)((Object)o);
        if (!Objects.equals((Object)this.attachMetadata, (Object)that.attachMetadata)) {
            return false;
        }
        if (!Objects.equals((Object)this.authorization, (Object)that.authorization)) {
            return false;
        }
        if (!Objects.equals(this._default, that._default)) {
            return false;
        }
        if (!Objects.equals(this.fallbackScrapeProtocol, that.fallbackScrapeProtocol)) {
            return false;
        }
        if (!Objects.equals(this.metricRelabelings, that.metricRelabelings)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.relabelings, that.relabelings)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsConfig, (Object)that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attachMetadata, this.authorization, this._default, this.fallbackScrapeProtocol, this.metricRelabelings, this.name, this.relabelings, this.tlsConfig, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachMetadata != null) {
            sb.append("attachMetadata:");
            sb.append(String.valueOf((Object)this.attachMetadata) + ",");
        }
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(String.valueOf((Object)this.authorization) + ",");
        }
        if (this._default != null) {
            sb.append("_default:");
            sb.append(this._default + ",");
        }
        if (this.fallbackScrapeProtocol != null) {
            sb.append("fallbackScrapeProtocol:");
            sb.append(this.fallbackScrapeProtocol + ",");
        }
        if (this.metricRelabelings != null && !this.metricRelabelings.isEmpty()) {
            sb.append("metricRelabelings:");
            sb.append(String.valueOf(this.metricRelabelings) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.relabelings != null && !this.relabelings.isEmpty()) {
            sb.append("relabelings:");
            sb.append(String.valueOf(this.relabelings) + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(String.valueOf((Object)this.tlsConfig) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDefault() {
        return this.withDefault(true);
    }

    public class TlsConfigNested<N>
    extends TLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        TLSConfigBuilder builder;

        TlsConfigNested(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)ScrapeClassFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class RelabelingsNested<N>
    extends RelabelConfigFluent<RelabelingsNested<N>>
    implements Nested<N> {
        RelabelConfigBuilder builder;
        int index;

        RelabelingsNested(int index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        public N and() {
            return (N)ScrapeClassFluent.this.setToRelabelings(this.index, this.builder.build());
        }

        public N endRelabeling() {
            return this.and();
        }
    }

    public class MetricRelabelingsNested<N>
    extends RelabelConfigFluent<MetricRelabelingsNested<N>>
    implements Nested<N> {
        RelabelConfigBuilder builder;
        int index;

        MetricRelabelingsNested(int index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        public N and() {
            return (N)ScrapeClassFluent.this.setToMetricRelabelings(this.index, this.builder.build());
        }

        public N endMetricRelabeling() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends AuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        AuthorizationBuilder builder;

        AuthorizationNested(Authorization item) {
            this.builder = new AuthorizationBuilder(this, item);
        }

        public N and() {
            return (N)ScrapeClassFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }

    public class AttachMetadataNested<N>
    extends AttachMetadataFluent<AttachMetadataNested<N>>
    implements Nested<N> {
        AttachMetadataBuilder builder;

        AttachMetadataNested(AttachMetadata item) {
            this.builder = new AttachMetadataBuilder(this, item);
        }

        public N and() {
            return (N)ScrapeClassFluent.this.withAttachMetadata(this.builder.build());
        }

        public N endAttachMetadata() {
            return this.and();
        }
    }
}

