/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.DiscordConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DiscordConfigFluent<A extends DiscordConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private SecretKeySelector apiURL;
    private String avatarURL;
    private String content;
    private HTTPConfigBuilder httpConfig;
    private String message;
    private Boolean sendResolved;
    private String title;
    private String username;

    public DiscordConfigFluent() {
    }

    public DiscordConfigFluent(DiscordConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    protected void copyInstance(DiscordConfig instance) {
        DiscordConfig discordConfig = instance = instance != null ? instance : new DiscordConfig();
        if (instance != null) {
            this.withApiURL(instance.getApiURL());
            this.withAvatarURL(instance.getAvatarURL());
            this.withContent(instance.getContent());
            this.withHttpConfig(instance.getHttpConfig());
            this.withMessage(instance.getMessage());
            this.withSendResolved(instance.getSendResolved());
            this.withTitle(instance.getTitle());
            this.withUsername(instance.getUsername());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DiscordConfigFluent that = (DiscordConfigFluent)((Object)o);
        if (!Objects.equals(this.apiURL, that.apiURL)) {
            return false;
        }
        if (!Objects.equals(this.avatarURL, that.avatarURL)) {
            return false;
        }
        if (!Objects.equals(this.content, that.content)) {
            return false;
        }
        if (!Objects.equals((Object)this.httpConfig, (Object)that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals(this.title, that.title)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public SecretKeySelector getApiURL() {
        return this.apiURL;
    }

    public String getAvatarURL() {
        return this.avatarURL;
    }

    public String getContent() {
        return this.content;
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiURL() {
        return this.apiURL != null;
    }

    public boolean hasAvatarURL() {
        return this.avatarURL != null;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiURL, this.avatarURL, this.content, this.httpConfig, this.message, this.sendResolved, this.title, this.username, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiURL != null) {
            sb.append("apiURL:");
            sb.append(this.apiURL);
            sb.append(",");
        }
        if (this.avatarURL != null) {
            sb.append("avatarURL:");
            sb.append(this.avatarURL);
            sb.append(",");
        }
        if (this.content != null) {
            sb.append("content:");
            sb.append(this.content);
            sb.append(",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append((Object)this.httpConfig);
            sb.append(",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message);
            sb.append(",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved);
            sb.append(",");
        }
        if (this.title != null) {
            sb.append("title:");
            sb.append(this.title);
            sb.append(",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiURL(SecretKeySelector apiURL) {
        this.apiURL = apiURL;
        return (A)((Object)this);
    }

    public A withAvatarURL(String avatarURL) {
        this.avatarURL = avatarURL;
        return (A)((Object)this);
    }

    public A withContent(String content) {
        this.content = content;
        return (A)((Object)this);
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove((Object)"httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get((Object)"httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get((Object)"httpConfig").remove((Object)this.httpConfig);
        }
        return (A)((Object)this);
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)((Object)this);
    }

    public A withNewApiURL(String key, String name, Boolean optional) {
        return this.withApiURL(new SecretKeySelector(key, name, optional));
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)((Object)this);
    }

    public A withTitle(String title) {
        this.title = title;
        return (A)((Object)this);
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)((Object)this);
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        public N and() {
            return (N)DiscordConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }
}

