package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
public class OAuth2ValidationErrorBuilder extends OAuth2ValidationErrorFluent<OAuth2ValidationErrorBuilder> implements VisitableBuilder<OAuth2ValidationError,OAuth2ValidationErrorBuilder>{

  OAuth2ValidationErrorFluent<?> fluent;

  public OAuth2ValidationErrorBuilder() {
    this(new OAuth2ValidationError());
  }
  
  public OAuth2ValidationErrorBuilder(OAuth2ValidationErrorFluent<?> fluent) {
    this(fluent, new OAuth2ValidationError());
  }
  
  public OAuth2ValidationErrorBuilder(OAuth2ValidationError instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  
  public OAuth2ValidationErrorBuilder(OAuth2ValidationErrorFluent<?> fluent,OAuth2ValidationError instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }

  public OAuth2ValidationError build() {
    OAuth2ValidationError buildable = new OAuth2ValidationError();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}