/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.OpenStackSDConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OpenStackSDConfigFluent<A extends OpenStackSDConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Boolean allTenants;
    private String applicationCredentialId;
    private String applicationCredentialName;
    private SecretKeySelector applicationCredentialSecret;
    private String availability;
    private String domainID;
    private String domainName;
    private String identityEndpoint;
    private SecretKeySelector password;
    private Integer port;
    private String projectID;
    private String projectName;
    private String refreshInterval;
    private String region;
    private String role;
    private SafeTLSConfigBuilder tlsConfig;
    private String userid;
    private String username;

    public OpenStackSDConfigFluent() {
    }

    public OpenStackSDConfigFluent(OpenStackSDConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public SafeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    protected void copyInstance(OpenStackSDConfig instance) {
        OpenStackSDConfig openStackSDConfig = instance = instance != null ? instance : new OpenStackSDConfig();
        if (instance != null) {
            this.withAllTenants(instance.getAllTenants());
            this.withApplicationCredentialId(instance.getApplicationCredentialId());
            this.withApplicationCredentialName(instance.getApplicationCredentialName());
            this.withApplicationCredentialSecret(instance.getApplicationCredentialSecret());
            this.withAvailability(instance.getAvailability());
            this.withDomainID(instance.getDomainID());
            this.withDomainName(instance.getDomainName());
            this.withIdentityEndpoint(instance.getIdentityEndpoint());
            this.withPassword(instance.getPassword());
            this.withPort(instance.getPort());
            this.withProjectID(instance.getProjectID());
            this.withProjectName(instance.getProjectName());
            this.withRefreshInterval(instance.getRefreshInterval());
            this.withRegion(instance.getRegion());
            this.withRole(instance.getRole());
            this.withTlsConfig(instance.getTlsConfig());
            this.withUserid(instance.getUserid());
            this.withUsername(instance.getUsername());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenStackSDConfigFluent that = (OpenStackSDConfigFluent)((Object)o);
        if (!Objects.equals(this.allTenants, that.allTenants)) {
            return false;
        }
        if (!Objects.equals(this.applicationCredentialId, that.applicationCredentialId)) {
            return false;
        }
        if (!Objects.equals(this.applicationCredentialName, that.applicationCredentialName)) {
            return false;
        }
        if (!Objects.equals(this.applicationCredentialSecret, that.applicationCredentialSecret)) {
            return false;
        }
        if (!Objects.equals(this.availability, that.availability)) {
            return false;
        }
        if (!Objects.equals(this.domainID, that.domainID)) {
            return false;
        }
        if (!Objects.equals(this.domainName, that.domainName)) {
            return false;
        }
        if (!Objects.equals(this.identityEndpoint, that.identityEndpoint)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.projectID, that.projectID)) {
            return false;
        }
        if (!Objects.equals(this.projectName, that.projectName)) {
            return false;
        }
        if (!Objects.equals(this.refreshInterval, that.refreshInterval)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.role, that.role)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsConfig, (Object)that.tlsConfig)) {
            return false;
        }
        if (!Objects.equals(this.userid, that.userid)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getAllTenants() {
        return this.allTenants;
    }

    public String getApplicationCredentialId() {
        return this.applicationCredentialId;
    }

    public String getApplicationCredentialName() {
        return this.applicationCredentialName;
    }

    public SecretKeySelector getApplicationCredentialSecret() {
        return this.applicationCredentialSecret;
    }

    public String getAvailability() {
        return this.availability;
    }

    public String getDomainID() {
        return this.domainID;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getIdentityEndpoint() {
        return this.identityEndpoint;
    }

    public SecretKeySelector getPassword() {
        return this.password;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRole() {
        return this.role;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAllTenants() {
        return this.allTenants != null;
    }

    public boolean hasApplicationCredentialId() {
        return this.applicationCredentialId != null;
    }

    public boolean hasApplicationCredentialName() {
        return this.applicationCredentialName != null;
    }

    public boolean hasApplicationCredentialSecret() {
        return this.applicationCredentialSecret != null;
    }

    public boolean hasAvailability() {
        return this.availability != null;
    }

    public boolean hasDomainID() {
        return this.domainID != null;
    }

    public boolean hasDomainName() {
        return this.domainName != null;
    }

    public boolean hasIdentityEndpoint() {
        return this.identityEndpoint != null;
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public boolean hasProjectID() {
        return this.projectID != null;
    }

    public boolean hasProjectName() {
        return this.projectName != null;
    }

    public boolean hasRefreshInterval() {
        return this.refreshInterval != null;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public boolean hasRole() {
        return this.role != null;
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public boolean hasUserid() {
        return this.userid != null;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allTenants, this.applicationCredentialId, this.applicationCredentialName, this.applicationCredentialSecret, this.availability, this.domainID, this.domainName, this.identityEndpoint, this.password, this.port, this.projectID, this.projectName, this.refreshInterval, this.region, this.role, this.tlsConfig, this.userid, this.username, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allTenants != null) {
            sb.append("allTenants:");
            sb.append(this.allTenants);
            sb.append(",");
        }
        if (this.applicationCredentialId != null) {
            sb.append("applicationCredentialId:");
            sb.append(this.applicationCredentialId);
            sb.append(",");
        }
        if (this.applicationCredentialName != null) {
            sb.append("applicationCredentialName:");
            sb.append(this.applicationCredentialName);
            sb.append(",");
        }
        if (this.applicationCredentialSecret != null) {
            sb.append("applicationCredentialSecret:");
            sb.append(this.applicationCredentialSecret);
            sb.append(",");
        }
        if (this.availability != null) {
            sb.append("availability:");
            sb.append(this.availability);
            sb.append(",");
        }
        if (this.domainID != null) {
            sb.append("domainID:");
            sb.append(this.domainID);
            sb.append(",");
        }
        if (this.domainName != null) {
            sb.append("domainName:");
            sb.append(this.domainName);
            sb.append(",");
        }
        if (this.identityEndpoint != null) {
            sb.append("identityEndpoint:");
            sb.append(this.identityEndpoint);
            sb.append(",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password);
            sb.append(",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port);
            sb.append(",");
        }
        if (this.projectID != null) {
            sb.append("projectID:");
            sb.append(this.projectID);
            sb.append(",");
        }
        if (this.projectName != null) {
            sb.append("projectName:");
            sb.append(this.projectName);
            sb.append(",");
        }
        if (this.refreshInterval != null) {
            sb.append("refreshInterval:");
            sb.append(this.refreshInterval);
            sb.append(",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region);
            sb.append(",");
        }
        if (this.role != null) {
            sb.append("role:");
            sb.append(this.role);
            sb.append(",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append((Object)this.tlsConfig);
            sb.append(",");
        }
        if (this.userid != null) {
            sb.append("userid:");
            sb.append(this.userid);
            sb.append(",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAllTenants() {
        return this.withAllTenants(true);
    }

    public A withAllTenants(Boolean allTenants) {
        this.allTenants = allTenants;
        return (A)((Object)this);
    }

    public A withApplicationCredentialId(String applicationCredentialId) {
        this.applicationCredentialId = applicationCredentialId;
        return (A)((Object)this);
    }

    public A withApplicationCredentialName(String applicationCredentialName) {
        this.applicationCredentialName = applicationCredentialName;
        return (A)((Object)this);
    }

    public A withApplicationCredentialSecret(SecretKeySelector applicationCredentialSecret) {
        this.applicationCredentialSecret = applicationCredentialSecret;
        return (A)((Object)this);
    }

    public A withAvailability(String availability) {
        this.availability = availability;
        return (A)((Object)this);
    }

    public A withDomainID(String domainID) {
        this.domainID = domainID;
        return (A)((Object)this);
    }

    public A withDomainName(String domainName) {
        this.domainName = domainName;
        return (A)((Object)this);
    }

    public A withIdentityEndpoint(String identityEndpoint) {
        this.identityEndpoint = identityEndpoint;
        return (A)((Object)this);
    }

    public A withNewApplicationCredentialSecret(String key, String name, Boolean optional) {
        return this.withApplicationCredentialSecret(new SecretKeySelector(key, name, optional));
    }

    public A withNewPassword(String key, String name, Boolean optional) {
        return this.withPassword(new SecretKeySelector(key, name, optional));
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
        return new TlsConfigNested(item);
    }

    public A withPassword(SecretKeySelector password) {
        this.password = password;
        return (A)((Object)this);
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)((Object)this);
    }

    public A withProjectID(String projectID) {
        this.projectID = projectID;
        return (A)((Object)this);
    }

    public A withProjectName(String projectName) {
        this.projectName = projectName;
        return (A)((Object)this);
    }

    public A withRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
        return (A)((Object)this);
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)((Object)this);
    }

    public A withRole(String role) {
        this.role = role;
        return (A)((Object)this);
    }

    public A withTlsConfig(SafeTLSConfig tlsConfig) {
        this._visitables.remove((Object)"tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
            this._visitables.get((Object)"tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get((Object)"tlsConfig").remove((Object)this.tlsConfig);
        }
        return (A)((Object)this);
    }

    public A withUserid(String userid) {
        this.userid = userid;
        return (A)((Object)this);
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)((Object)this);
    }

    public class TlsConfigNested<N>
    extends SafeTLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        SafeTLSConfigBuilder builder;

        TlsConfigNested(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)OpenStackSDConfigFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }
}

