/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.ScalewaySDConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ScalewaySDConfigFluent<A extends ScalewaySDConfigFluent<A>>
extends BaseFluent<A> {
    private String accessKey;
    private Map<String, Object> additionalProperties;
    private String apiURL;
    private Boolean enableHTTP2;
    private Boolean followRedirects;
    private String nameFilter;
    private String noProxy;
    private Integer port;
    private String projectID;
    private Map<String, List<SecretKeySelector>> proxyConnectHeader;
    private Boolean proxyFromEnvironment;
    private String proxyUrl;
    private String refreshInterval;
    private String role;
    private SecretKeySelector secretKey;
    private List<String> tagsFilter = new ArrayList<String>();
    private SafeTLSConfigBuilder tlsConfig;
    private String zone;

    public ScalewaySDConfigFluent() {
    }

    public ScalewaySDConfigFluent(ScalewaySDConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToTagsFilter(Collection<String> items) {
        if (this.tagsFilter == null) {
            this.tagsFilter = new ArrayList<String>();
        }
        for (String item : items) {
            this.tagsFilter.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null && map != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (map != null) {
            this.proxyConnectHeader.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToProxyConnectHeader(String key, List<SecretKeySelector> value) {
        if (this.proxyConnectHeader == null && key != null && value != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (key != null && value != null) {
            this.proxyConnectHeader.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTagsFilter(String ... items) {
        if (this.tagsFilter == null) {
            this.tagsFilter = new ArrayList<String>();
        }
        for (String item : items) {
            this.tagsFilter.add(item);
        }
        return (A)((Object)this);
    }

    public A addToTagsFilter(int index, String item) {
        if (this.tagsFilter == null) {
            this.tagsFilter = new ArrayList<String>();
        }
        this.tagsFilter.add(index, item);
        return (A)((Object)this);
    }

    public SafeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    protected void copyInstance(ScalewaySDConfig instance) {
        ScalewaySDConfig scalewaySDConfig = instance = instance != null ? instance : new ScalewaySDConfig();
        if (instance != null) {
            this.withAccessKey(instance.getAccessKey());
            this.withApiURL(instance.getApiURL());
            this.withEnableHTTP2(instance.getEnableHTTP2());
            this.withFollowRedirects(instance.getFollowRedirects());
            this.withNameFilter(instance.getNameFilter());
            this.withNoProxy(instance.getNoProxy());
            this.withPort(instance.getPort());
            this.withProjectID(instance.getProjectID());
            this.withProxyConnectHeader(instance.getProxyConnectHeader());
            this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
            this.withProxyUrl(instance.getProxyUrl());
            this.withRefreshInterval(instance.getRefreshInterval());
            this.withRole(instance.getRole());
            this.withSecretKey(instance.getSecretKey());
            this.withTagsFilter(instance.getTagsFilter());
            this.withTlsConfig(instance.getTlsConfig());
            this.withZone(instance.getZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScalewaySDConfigFluent that = (ScalewaySDConfigFluent)((Object)o);
        if (!Objects.equals(this.accessKey, that.accessKey)) {
            return false;
        }
        if (!Objects.equals(this.apiURL, that.apiURL)) {
            return false;
        }
        if (!Objects.equals(this.enableHTTP2, that.enableHTTP2)) {
            return false;
        }
        if (!Objects.equals(this.followRedirects, that.followRedirects)) {
            return false;
        }
        if (!Objects.equals(this.nameFilter, that.nameFilter)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.projectID, that.projectID)) {
            return false;
        }
        if (!Objects.equals(this.proxyConnectHeader, that.proxyConnectHeader)) {
            return false;
        }
        if (!Objects.equals(this.proxyFromEnvironment, that.proxyFromEnvironment)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.refreshInterval, that.refreshInterval)) {
            return false;
        }
        if (!Objects.equals(this.role, that.role)) {
            return false;
        }
        if (!Objects.equals(this.secretKey, that.secretKey)) {
            return false;
        }
        if (!Objects.equals(this.tagsFilter, that.tagsFilter)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsConfig, (Object)that.tlsConfig)) {
            return false;
        }
        if (!Objects.equals(this.zone, that.zone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public Boolean getEnableHTTP2() {
        return this.enableHTTP2;
    }

    public String getFirstTagsFilter() {
        return this.tagsFilter.get(0);
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public String getLastTagsFilter() {
        return this.tagsFilter.get(this.tagsFilter.size() - 1);
    }

    public String getMatchingTagsFilter(Predicate<String> predicate) {
        for (String item : this.tagsFilter) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getNameFilter() {
        return this.nameFilter;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public Map<String, List<SecretKeySelector>> getProxyConnectHeader() {
        return this.proxyConnectHeader;
    }

    public Boolean getProxyFromEnvironment() {
        return this.proxyFromEnvironment;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public String getRole() {
        return this.role;
    }

    public SecretKeySelector getSecretKey() {
        return this.secretKey;
    }

    public List<String> getTagsFilter() {
        return this.tagsFilter;
    }

    public String getTagsFilter(int index) {
        return this.tagsFilter.get(index);
    }

    public String getZone() {
        return this.zone;
    }

    public boolean hasAccessKey() {
        return this.accessKey != null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiURL() {
        return this.apiURL != null;
    }

    public boolean hasEnableHTTP2() {
        return this.enableHTTP2 != null;
    }

    public boolean hasFollowRedirects() {
        return this.followRedirects != null;
    }

    public boolean hasMatchingTagsFilter(Predicate<String> predicate) {
        for (String item : this.tagsFilter) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameFilter() {
        return this.nameFilter != null;
    }

    public boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public boolean hasProjectID() {
        return this.projectID != null;
    }

    public boolean hasProxyConnectHeader() {
        return this.proxyConnectHeader != null;
    }

    public boolean hasProxyFromEnvironment() {
        return this.proxyFromEnvironment != null;
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public boolean hasRefreshInterval() {
        return this.refreshInterval != null;
    }

    public boolean hasRole() {
        return this.role != null;
    }

    public boolean hasSecretKey() {
        return this.secretKey != null;
    }

    public boolean hasTagsFilter() {
        return this.tagsFilter != null && !this.tagsFilter.isEmpty();
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessKey, this.apiURL, this.enableHTTP2, this.followRedirects, this.nameFilter, this.noProxy, this.port, this.projectID, this.proxyConnectHeader, this.proxyFromEnvironment, this.proxyUrl, this.refreshInterval, this.role, this.secretKey, this.tagsFilter, this.tlsConfig, this.zone, this.additionalProperties});
    }

    public A removeAllFromTagsFilter(Collection<String> items) {
        if (this.tagsFilter == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tagsFilter.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromProxyConnectHeader(String key) {
        if (this.proxyConnectHeader == null) {
            return (A)((Object)this);
        }
        if (key != null && this.proxyConnectHeader != null) {
            this.proxyConnectHeader.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.proxyConnectHeader == null) continue;
                this.proxyConnectHeader.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromTagsFilter(String ... items) {
        if (this.tagsFilter == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tagsFilter.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToTagsFilter(int index, String item) {
        if (this.tagsFilter == null) {
            this.tagsFilter = new ArrayList<String>();
        }
        this.tagsFilter.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accessKey != null) {
            sb.append("accessKey:");
            sb.append(this.accessKey);
            sb.append(",");
        }
        if (this.apiURL != null) {
            sb.append("apiURL:");
            sb.append(this.apiURL);
            sb.append(",");
        }
        if (this.enableHTTP2 != null) {
            sb.append("enableHTTP2:");
            sb.append(this.enableHTTP2);
            sb.append(",");
        }
        if (this.followRedirects != null) {
            sb.append("followRedirects:");
            sb.append(this.followRedirects);
            sb.append(",");
        }
        if (this.nameFilter != null) {
            sb.append("nameFilter:");
            sb.append(this.nameFilter);
            sb.append(",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy);
            sb.append(",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port);
            sb.append(",");
        }
        if (this.projectID != null) {
            sb.append("projectID:");
            sb.append(this.projectID);
            sb.append(",");
        }
        if (this.proxyConnectHeader != null && !this.proxyConnectHeader.isEmpty()) {
            sb.append("proxyConnectHeader:");
            sb.append(this.proxyConnectHeader);
            sb.append(",");
        }
        if (this.proxyFromEnvironment != null) {
            sb.append("proxyFromEnvironment:");
            sb.append(this.proxyFromEnvironment);
            sb.append(",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl);
            sb.append(",");
        }
        if (this.refreshInterval != null) {
            sb.append("refreshInterval:");
            sb.append(this.refreshInterval);
            sb.append(",");
        }
        if (this.role != null) {
            sb.append("role:");
            sb.append(this.role);
            sb.append(",");
        }
        if (this.secretKey != null) {
            sb.append("secretKey:");
            sb.append(this.secretKey);
            sb.append(",");
        }
        if (this.tagsFilter != null && !this.tagsFilter.isEmpty()) {
            sb.append("tagsFilter:");
            sb.append(this.tagsFilter);
            sb.append(",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append((Object)this.tlsConfig);
            sb.append(",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return (A)((Object)this);
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiURL(String apiURL) {
        this.apiURL = apiURL;
        return (A)((Object)this);
    }

    public A withEnableHTTP2() {
        return this.withEnableHTTP2(true);
    }

    public A withEnableHTTP2(Boolean enableHTTP2) {
        this.enableHTTP2 = enableHTTP2;
        return (A)((Object)this);
    }

    public A withFollowRedirects() {
        return this.withFollowRedirects(true);
    }

    public A withFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return (A)((Object)this);
    }

    public A withNameFilter(String nameFilter) {
        this.nameFilter = nameFilter;
        return (A)((Object)this);
    }

    public A withNewSecretKey(String key, String name, Boolean optional) {
        return this.withSecretKey(new SecretKeySelector(key, name, optional));
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
        return new TlsConfigNested(item);
    }

    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)((Object)this);
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)((Object)this);
    }

    public A withProjectID(String projectID) {
        this.projectID = projectID;
        return (A)((Object)this);
    }

    public <K, V> A withProxyConnectHeader(Map<String, List<SecretKeySelector>> proxyConnectHeader) {
        this.proxyConnectHeader = proxyConnectHeader == null ? null : new LinkedHashMap<String, List<SecretKeySelector>>(proxyConnectHeader);
        return (A)((Object)this);
    }

    public A withProxyFromEnvironment() {
        return this.withProxyFromEnvironment(true);
    }

    public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
        this.proxyFromEnvironment = proxyFromEnvironment;
        return (A)((Object)this);
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)((Object)this);
    }

    public A withRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
        return (A)((Object)this);
    }

    public A withRole(String role) {
        this.role = role;
        return (A)((Object)this);
    }

    public A withSecretKey(SecretKeySelector secretKey) {
        this.secretKey = secretKey;
        return (A)((Object)this);
    }

    public A withTagsFilter(List<String> tagsFilter) {
        if (tagsFilter != null) {
            this.tagsFilter = new ArrayList<String>();
            for (String item : tagsFilter) {
                this.addToTagsFilter(item);
            }
        } else {
            this.tagsFilter = null;
        }
        return (A)((Object)this);
    }

    public A withTagsFilter(String ... tagsFilter) {
        if (this.tagsFilter != null) {
            this.tagsFilter.clear();
            this._visitables.remove((Object)"tagsFilter");
        }
        if (tagsFilter != null) {
            for (String item : tagsFilter) {
                this.addToTagsFilter(item);
            }
        }
        return (A)((Object)this);
    }

    public A withTlsConfig(SafeTLSConfig tlsConfig) {
        this._visitables.remove((Object)"tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
            this._visitables.get((Object)"tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get((Object)"tlsConfig").remove((Object)this.tlsConfig);
        }
        return (A)((Object)this);
    }

    public A withZone(String zone) {
        this.zone = zone;
        return (A)((Object)this);
    }

    public class TlsConfigNested<N>
    extends SafeTLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        SafeTLSConfigBuilder builder;

        TlsConfigNested(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)ScalewaySDConfigFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }
}

