/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.SecretNameReference;
import io.fabric8.openshift.api.model.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.SecretNameReferenceFluent;
import io.fabric8.openshift.api.model.SecretNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute;
import io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteFluent;
import java.util.Objects;

public class ConsoleConfigRouteFluentImpl<A extends ConsoleConfigRouteFluent<A>>
extends BaseFluent<A>
implements ConsoleConfigRouteFluent<A> {
    private String hostname;
    private SecretNameReferenceBuilder secret;

    public ConsoleConfigRouteFluentImpl() {
    }

    public ConsoleConfigRouteFluentImpl(ConsoleConfigRoute instance) {
        this.withHostname(instance.getHostname());
        this.withSecret(instance.getSecret());
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    @Deprecated
    public A withNewHostname(String arg0) {
        return this.withHostname(new String(arg0));
    }

    @Override
    @Deprecated
    public SecretNameReference getSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    @Override
    public SecretNameReference buildSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    @Override
    public A withSecret(SecretNameReference secret) {
        this._visitables.get((Object)"secret").remove(this.secret);
        if (secret != null) {
            this.secret = new SecretNameReferenceBuilder(secret);
            this._visitables.get((Object)"secret").add(this.secret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecret() {
        return this.secret != null;
    }

    @Override
    public A withNewSecret(String name) {
        return this.withSecret(new SecretNameReference(name));
    }

    @Override
    public ConsoleConfigRouteFluent.SecretNested<A> withNewSecret() {
        return new SecretNestedImpl();
    }

    @Override
    public ConsoleConfigRouteFluent.SecretNested<A> withNewSecretLike(SecretNameReference item) {
        return new SecretNestedImpl(item);
    }

    @Override
    public ConsoleConfigRouteFluent.SecretNested<A> editSecret() {
        return this.withNewSecretLike(this.getSecret());
    }

    @Override
    public ConsoleConfigRouteFluent.SecretNested<A> editOrNewSecret() {
        return this.withNewSecretLike(this.getSecret() != null ? this.getSecret() : new SecretNameReferenceBuilder().build());
    }

    @Override
    public ConsoleConfigRouteFluent.SecretNested<A> editOrNewSecretLike(SecretNameReference item) {
        return this.withNewSecretLike(this.getSecret() != null ? this.getSecret() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsoleConfigRouteFluentImpl that = (ConsoleConfigRouteFluentImpl)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        return !(this.secret != null ? !this.secret.equals((Object)that.secret) : that.secret != null);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.secret, super.hashCode());
    }

    public class SecretNestedImpl<N>
    extends SecretNameReferenceFluentImpl<ConsoleConfigRouteFluent.SecretNested<N>>
    implements ConsoleConfigRouteFluent.SecretNested<N>,
    Nested<N> {
        private final SecretNameReferenceBuilder builder;

        SecretNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder((SecretNameReferenceFluent)this, item);
        }

        SecretNestedImpl() {
            this.builder = new SecretNameReferenceBuilder((SecretNameReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)ConsoleConfigRouteFluentImpl.this.withSecret(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }
}

