package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AuthenticationSpecBuilder extends AuthenticationSpecFluent<AuthenticationSpecBuilder> implements VisitableBuilder<AuthenticationSpec,AuthenticationSpecBuilder>{
  public AuthenticationSpecBuilder() {
    this(new AuthenticationSpec());
  }
  
  public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent) {
    this(fluent, new AuthenticationSpec());
  }
  
  public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent,AuthenticationSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AuthenticationSpecBuilder(AuthenticationSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AuthenticationSpecFluent<?> fluent;
  
  public AuthenticationSpec build() {
    AuthenticationSpec buildable = new AuthenticationSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}