package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OVNKubernetesConfigFluentImpl<A extends OVNKubernetesConfigFluent<A>> extends BaseFluent<A> implements OVNKubernetesConfigFluent<A>{
  public OVNKubernetesConfigFluentImpl() {
  }
  public OVNKubernetesConfigFluentImpl(OVNKubernetesConfig instance) {
    this.withGenevePort(instance.getGenevePort()); 
    this.withHybridOverlayConfig(instance.getHybridOverlayConfig()); 
    this.withIpsecConfig(instance.getIpsecConfig()); 
    this.withMtu(instance.getMtu()); 
    this.withPolicyAuditConfig(instance.getPolicyAuditConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer genevePort;
  private HybridOverlayConfigBuilder hybridOverlayConfig;
  private IPsecConfigBuilder ipsecConfig;
  private Integer mtu;
  private PolicyAuditConfigBuilder policyAuditConfig;
  private Map<String,Object> additionalProperties;
  public Integer getGenevePort() {
    return this.genevePort;
  }
  public A withGenevePort(Integer genevePort) {
    this.genevePort=genevePort; return (A) this;
  }
  public Boolean hasGenevePort() {
    return this.genevePort != null;
  }
  
  /**
   * This method has been deprecated, please use method buildHybridOverlayConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HybridOverlayConfig getHybridOverlayConfig() {
    return this.hybridOverlayConfig!=null ?this.hybridOverlayConfig.build():null;
  }
  public HybridOverlayConfig buildHybridOverlayConfig() {
    return this.hybridOverlayConfig!=null ?this.hybridOverlayConfig.build():null;
  }
  public A withHybridOverlayConfig(HybridOverlayConfig hybridOverlayConfig) {
    _visitables.get("hybridOverlayConfig").remove(this.hybridOverlayConfig);
    if (hybridOverlayConfig!=null){ this.hybridOverlayConfig= new HybridOverlayConfigBuilder(hybridOverlayConfig); _visitables.get("hybridOverlayConfig").add(this.hybridOverlayConfig);} else { this.hybridOverlayConfig = null; _visitables.get("hybridOverlayConfig").remove(this.hybridOverlayConfig); } return (A) this;
  }
  public Boolean hasHybridOverlayConfig() {
    return this.hybridOverlayConfig != null;
  }
  public OVNKubernetesConfigFluent.HybridOverlayConfigNested<A> withNewHybridOverlayConfig() {
    return new OVNKubernetesConfigFluentImpl.HybridOverlayConfigNestedImpl();
  }
  public OVNKubernetesConfigFluent.HybridOverlayConfigNested<A> withNewHybridOverlayConfigLike(HybridOverlayConfig item) {
    return new OVNKubernetesConfigFluentImpl.HybridOverlayConfigNestedImpl(item);
  }
  public OVNKubernetesConfigFluent.HybridOverlayConfigNested<A> editHybridOverlayConfig() {
    return withNewHybridOverlayConfigLike(getHybridOverlayConfig());
  }
  public OVNKubernetesConfigFluent.HybridOverlayConfigNested<A> editOrNewHybridOverlayConfig() {
    return withNewHybridOverlayConfigLike(getHybridOverlayConfig() != null ? getHybridOverlayConfig(): new HybridOverlayConfigBuilder().build());
  }
  public OVNKubernetesConfigFluent.HybridOverlayConfigNested<A> editOrNewHybridOverlayConfigLike(HybridOverlayConfig item) {
    return withNewHybridOverlayConfigLike(getHybridOverlayConfig() != null ? getHybridOverlayConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildIpsecConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public IPsecConfig getIpsecConfig() {
    return this.ipsecConfig!=null ?this.ipsecConfig.build():null;
  }
  public IPsecConfig buildIpsecConfig() {
    return this.ipsecConfig!=null ?this.ipsecConfig.build():null;
  }
  public A withIpsecConfig(IPsecConfig ipsecConfig) {
    _visitables.get("ipsecConfig").remove(this.ipsecConfig);
    if (ipsecConfig!=null){ this.ipsecConfig= new IPsecConfigBuilder(ipsecConfig); _visitables.get("ipsecConfig").add(this.ipsecConfig);} else { this.ipsecConfig = null; _visitables.get("ipsecConfig").remove(this.ipsecConfig); } return (A) this;
  }
  public Boolean hasIpsecConfig() {
    return this.ipsecConfig != null;
  }
  public OVNKubernetesConfigFluent.IpsecConfigNested<A> withNewIpsecConfig() {
    return new OVNKubernetesConfigFluentImpl.IpsecConfigNestedImpl();
  }
  public OVNKubernetesConfigFluent.IpsecConfigNested<A> withNewIpsecConfigLike(IPsecConfig item) {
    return new OVNKubernetesConfigFluentImpl.IpsecConfigNestedImpl(item);
  }
  public OVNKubernetesConfigFluent.IpsecConfigNested<A> editIpsecConfig() {
    return withNewIpsecConfigLike(getIpsecConfig());
  }
  public OVNKubernetesConfigFluent.IpsecConfigNested<A> editOrNewIpsecConfig() {
    return withNewIpsecConfigLike(getIpsecConfig() != null ? getIpsecConfig(): new IPsecConfigBuilder().build());
  }
  public OVNKubernetesConfigFluent.IpsecConfigNested<A> editOrNewIpsecConfigLike(IPsecConfig item) {
    return withNewIpsecConfigLike(getIpsecConfig() != null ? getIpsecConfig(): item);
  }
  public Integer getMtu() {
    return this.mtu;
  }
  public A withMtu(Integer mtu) {
    this.mtu=mtu; return (A) this;
  }
  public Boolean hasMtu() {
    return this.mtu != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPolicyAuditConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public PolicyAuditConfig getPolicyAuditConfig() {
    return this.policyAuditConfig!=null ?this.policyAuditConfig.build():null;
  }
  public PolicyAuditConfig buildPolicyAuditConfig() {
    return this.policyAuditConfig!=null ?this.policyAuditConfig.build():null;
  }
  public A withPolicyAuditConfig(PolicyAuditConfig policyAuditConfig) {
    _visitables.get("policyAuditConfig").remove(this.policyAuditConfig);
    if (policyAuditConfig!=null){ this.policyAuditConfig= new PolicyAuditConfigBuilder(policyAuditConfig); _visitables.get("policyAuditConfig").add(this.policyAuditConfig);} else { this.policyAuditConfig = null; _visitables.get("policyAuditConfig").remove(this.policyAuditConfig); } return (A) this;
  }
  public Boolean hasPolicyAuditConfig() {
    return this.policyAuditConfig != null;
  }
  public A withNewPolicyAuditConfig(String destination,Integer maxFileSize,Integer rateLimit,String syslogFacility) {
    return (A)withPolicyAuditConfig(new PolicyAuditConfig(destination, maxFileSize, rateLimit, syslogFacility));
  }
  public OVNKubernetesConfigFluent.PolicyAuditConfigNested<A> withNewPolicyAuditConfig() {
    return new OVNKubernetesConfigFluentImpl.PolicyAuditConfigNestedImpl();
  }
  public OVNKubernetesConfigFluent.PolicyAuditConfigNested<A> withNewPolicyAuditConfigLike(PolicyAuditConfig item) {
    return new OVNKubernetesConfigFluentImpl.PolicyAuditConfigNestedImpl(item);
  }
  public OVNKubernetesConfigFluent.PolicyAuditConfigNested<A> editPolicyAuditConfig() {
    return withNewPolicyAuditConfigLike(getPolicyAuditConfig());
  }
  public OVNKubernetesConfigFluent.PolicyAuditConfigNested<A> editOrNewPolicyAuditConfig() {
    return withNewPolicyAuditConfigLike(getPolicyAuditConfig() != null ? getPolicyAuditConfig(): new PolicyAuditConfigBuilder().build());
  }
  public OVNKubernetesConfigFluent.PolicyAuditConfigNested<A> editOrNewPolicyAuditConfigLike(PolicyAuditConfig item) {
    return withNewPolicyAuditConfigLike(getPolicyAuditConfig() != null ? getPolicyAuditConfig(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OVNKubernetesConfigFluentImpl that = (OVNKubernetesConfigFluentImpl) o;
    if (genevePort != null ? !genevePort.equals(that.genevePort) :that.genevePort != null) return false;
    if (hybridOverlayConfig != null ? !hybridOverlayConfig.equals(that.hybridOverlayConfig) :that.hybridOverlayConfig != null) return false;
    if (ipsecConfig != null ? !ipsecConfig.equals(that.ipsecConfig) :that.ipsecConfig != null) return false;
    if (mtu != null ? !mtu.equals(that.mtu) :that.mtu != null) return false;
    if (policyAuditConfig != null ? !policyAuditConfig.equals(that.policyAuditConfig) :that.policyAuditConfig != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(genevePort,  hybridOverlayConfig,  ipsecConfig,  mtu,  policyAuditConfig,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (genevePort != null) { sb.append("genevePort:"); sb.append(genevePort + ","); }
    if (hybridOverlayConfig != null) { sb.append("hybridOverlayConfig:"); sb.append(hybridOverlayConfig + ","); }
    if (ipsecConfig != null) { sb.append("ipsecConfig:"); sb.append(ipsecConfig + ","); }
    if (mtu != null) { sb.append("mtu:"); sb.append(mtu + ","); }
    if (policyAuditConfig != null) { sb.append("policyAuditConfig:"); sb.append(policyAuditConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class HybridOverlayConfigNestedImpl<N> extends HybridOverlayConfigFluentImpl<OVNKubernetesConfigFluent.HybridOverlayConfigNested<N>> implements OVNKubernetesConfigFluent.HybridOverlayConfigNested<N>,Nested<N>{
    HybridOverlayConfigNestedImpl(HybridOverlayConfig item) {
      this.builder = new HybridOverlayConfigBuilder(this, item);
    }
    HybridOverlayConfigNestedImpl() {
      this.builder = new HybridOverlayConfigBuilder(this);
    }
    HybridOverlayConfigBuilder builder;
    public N and() {
      return (N) OVNKubernetesConfigFluentImpl.this.withHybridOverlayConfig(builder.build());
    }
    public N endHybridOverlayConfig() {
      return and();
    }
    
  }
  class IpsecConfigNestedImpl<N> extends IPsecConfigFluentImpl<OVNKubernetesConfigFluent.IpsecConfigNested<N>> implements OVNKubernetesConfigFluent.IpsecConfigNested<N>,Nested<N>{
    IpsecConfigNestedImpl(IPsecConfig item) {
      this.builder = new IPsecConfigBuilder(this, item);
    }
    IpsecConfigNestedImpl() {
      this.builder = new IPsecConfigBuilder(this);
    }
    IPsecConfigBuilder builder;
    public N and() {
      return (N) OVNKubernetesConfigFluentImpl.this.withIpsecConfig(builder.build());
    }
    public N endIpsecConfig() {
      return and();
    }
    
  }
  class PolicyAuditConfigNestedImpl<N> extends PolicyAuditConfigFluentImpl<OVNKubernetesConfigFluent.PolicyAuditConfigNested<N>> implements OVNKubernetesConfigFluent.PolicyAuditConfigNested<N>,Nested<N>{
    PolicyAuditConfigNestedImpl(PolicyAuditConfig item) {
      this.builder = new PolicyAuditConfigBuilder(this, item);
    }
    PolicyAuditConfigNestedImpl() {
      this.builder = new PolicyAuditConfigBuilder(this);
    }
    PolicyAuditConfigBuilder builder;
    public N and() {
      return (N) OVNKubernetesConfigFluentImpl.this.withPolicyAuditConfig(builder.build());
    }
    public N endPolicyAuditConfig() {
      return and();
    }
    
  }
  
}