package io.fabric8.openshift.api.model.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OutageEntryFluentImpl<A extends OutageEntryFluent<A>> extends BaseFluent<A> implements OutageEntryFluent<A>{
  public OutageEntryFluentImpl() {
  }
  public OutageEntryFluentImpl(OutageEntry instance) {
    if (instance != null) {
      this.withEnd(instance.getEnd());
      this.withEndLogs(instance.getEndLogs());
      this.withMessage(instance.getMessage());
      this.withStart(instance.getStart());
      this.withStartLogs(instance.getStartLogs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String end;
  private ArrayList<LogEntryBuilder> endLogs = new ArrayList<LogEntryBuilder>();
  private String message;
  private String start;
  private ArrayList<LogEntryBuilder> startLogs = new ArrayList<LogEntryBuilder>();
  private Map<String,Object> additionalProperties;
  public String getEnd() {
    return this.end;
  }
  public A withEnd(String end) {
    this.end=end; return (A) this;
  }
  public Boolean hasEnd() {
    return this.end != null;
  }
  public A addToEndLogs(int index,LogEntry item) {
    if (this.endLogs == null) {this.endLogs = new ArrayList<LogEntryBuilder>();}
    LogEntryBuilder builder = new LogEntryBuilder(item);
    if (index < 0 || index >= endLogs.size()) { _visitables.get("endLogs").add(builder); endLogs.add(builder); } else { _visitables.get("endLogs").add(index, builder); endLogs.add(index, builder);}
    return (A)this;
  }
  public A setToEndLogs(int index,LogEntry item) {
    if (this.endLogs == null) {this.endLogs = new ArrayList<LogEntryBuilder>();}
    LogEntryBuilder builder = new LogEntryBuilder(item);
    if (index < 0 || index >= endLogs.size()) { _visitables.get("endLogs").add(builder); endLogs.add(builder); } else { _visitables.get("endLogs").set(index, builder); endLogs.set(index, builder);}
    return (A)this;
  }
  public A addToEndLogs(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntry... items) {
    if (this.endLogs == null) {this.endLogs = new ArrayList<LogEntryBuilder>();}
    for (LogEntry item : items) {LogEntryBuilder builder = new LogEntryBuilder(item);_visitables.get("endLogs").add(builder);this.endLogs.add(builder);} return (A)this;
  }
  public A addAllToEndLogs(Collection<LogEntry> items) {
    if (this.endLogs == null) {this.endLogs = new ArrayList<LogEntryBuilder>();}
    for (LogEntry item : items) {LogEntryBuilder builder = new LogEntryBuilder(item);_visitables.get("endLogs").add(builder);this.endLogs.add(builder);} return (A)this;
  }
  public A removeFromEndLogs(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntry... items) {
    for (LogEntry item : items) {LogEntryBuilder builder = new LogEntryBuilder(item);_visitables.get("endLogs").remove(builder);if (this.endLogs != null) {this.endLogs.remove(builder);}} return (A)this;
  }
  public A removeAllFromEndLogs(Collection<LogEntry> items) {
    for (LogEntry item : items) {LogEntryBuilder builder = new LogEntryBuilder(item);_visitables.get("endLogs").remove(builder);if (this.endLogs != null) {this.endLogs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEndLogs(Predicate<LogEntryBuilder> predicate) {
    if (endLogs == null) return (A) this;
    final Iterator<LogEntryBuilder> each = endLogs.iterator();
    final List visitables = _visitables.get("endLogs");
    while (each.hasNext()) {
      LogEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEndLogs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LogEntry> getEndLogs() {
    return endLogs != null ? build(endLogs) : null;
  }
  public List<LogEntry> buildEndLogs() {
    return endLogs != null ? build(endLogs) : null;
  }
  public LogEntry buildEndLog(int index) {
    return this.endLogs.get(index).build();
  }
  public LogEntry buildFirstEndLog() {
    return this.endLogs.get(0).build();
  }
  public LogEntry buildLastEndLog() {
    return this.endLogs.get(endLogs.size() - 1).build();
  }
  public LogEntry buildMatchingEndLog(Predicate<LogEntryBuilder> predicate) {
    for (LogEntryBuilder item: endLogs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEndLog(Predicate<LogEntryBuilder> predicate) {
    for (LogEntryBuilder item: endLogs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEndLogs(List<LogEntry> endLogs) {
    if (this.endLogs != null) { _visitables.get("endLogs").clear();}
    if (endLogs != null) {this.endLogs = new ArrayList(); for (LogEntry item : endLogs){this.addToEndLogs(item);}} else { this.endLogs = null;} return (A) this;
  }
  public A withEndLogs(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntry... endLogs) {
    if (this.endLogs != null) {this.endLogs.clear(); _visitables.remove("endLogs"); }
    if (endLogs != null) {for (LogEntry item :endLogs){ this.addToEndLogs(item);}} return (A) this;
  }
  public Boolean hasEndLogs() {
    return endLogs != null && !endLogs.isEmpty();
  }
  public OutageEntryFluentImpl.EndLogsNested<A> addNewEndLog() {
    return new OutageEntryFluentImpl.EndLogsNestedImpl();
  }
  public OutageEntryFluentImpl.EndLogsNested<A> addNewEndLogLike(LogEntry item) {
    return new OutageEntryFluentImpl.EndLogsNestedImpl(-1, item);
  }
  public OutageEntryFluentImpl.EndLogsNested<A> setNewEndLogLike(int index,LogEntry item) {
    return new OutageEntryFluentImpl.EndLogsNestedImpl(index, item);
  }
  public OutageEntryFluentImpl.EndLogsNested<A> editEndLog(int index) {
    if (endLogs.size() <= index) throw new RuntimeException("Can't edit endLogs. Index exceeds size.");
    return setNewEndLogLike(index, buildEndLog(index));
  }
  public OutageEntryFluentImpl.EndLogsNested<A> editFirstEndLog() {
    if (endLogs.size() == 0) throw new RuntimeException("Can't edit first endLogs. The list is empty.");
    return setNewEndLogLike(0, buildEndLog(0));
  }
  public OutageEntryFluentImpl.EndLogsNested<A> editLastEndLog() {
    int index = endLogs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endLogs. The list is empty.");
    return setNewEndLogLike(index, buildEndLog(index));
  }
  public OutageEntryFluentImpl.EndLogsNested<A> editMatchingEndLog(Predicate<LogEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endLogs.size();i++) { 
    if (predicate.test(endLogs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endLogs. No match found.");
    return setNewEndLogLike(index, buildEndLog(index));
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public Boolean hasMessage() {
    return this.message != null;
  }
  public String getStart() {
    return this.start;
  }
  public A withStart(String start) {
    this.start=start; return (A) this;
  }
  public Boolean hasStart() {
    return this.start != null;
  }
  public A addToStartLogs(int index,LogEntry item) {
    if (this.startLogs == null) {this.startLogs = new ArrayList<LogEntryBuilder>();}
    LogEntryBuilder builder = new LogEntryBuilder(item);
    if (index < 0 || index >= startLogs.size()) { _visitables.get("startLogs").add(builder); startLogs.add(builder); } else { _visitables.get("startLogs").add(index, builder); startLogs.add(index, builder);}
    return (A)this;
  }
  public A setToStartLogs(int index,LogEntry item) {
    if (this.startLogs == null) {this.startLogs = new ArrayList<LogEntryBuilder>();}
    LogEntryBuilder builder = new LogEntryBuilder(item);
    if (index < 0 || index >= startLogs.size()) { _visitables.get("startLogs").add(builder); startLogs.add(builder); } else { _visitables.get("startLogs").set(index, builder); startLogs.set(index, builder);}
    return (A)this;
  }
  public A addToStartLogs(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntry... items) {
    if (this.startLogs == null) {this.startLogs = new ArrayList<LogEntryBuilder>();}
    for (LogEntry item : items) {LogEntryBuilder builder = new LogEntryBuilder(item);_visitables.get("startLogs").add(builder);this.startLogs.add(builder);} return (A)this;
  }
  public A addAllToStartLogs(Collection<LogEntry> items) {
    if (this.startLogs == null) {this.startLogs = new ArrayList<LogEntryBuilder>();}
    for (LogEntry item : items) {LogEntryBuilder builder = new LogEntryBuilder(item);_visitables.get("startLogs").add(builder);this.startLogs.add(builder);} return (A)this;
  }
  public A removeFromStartLogs(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntry... items) {
    for (LogEntry item : items) {LogEntryBuilder builder = new LogEntryBuilder(item);_visitables.get("startLogs").remove(builder);if (this.startLogs != null) {this.startLogs.remove(builder);}} return (A)this;
  }
  public A removeAllFromStartLogs(Collection<LogEntry> items) {
    for (LogEntry item : items) {LogEntryBuilder builder = new LogEntryBuilder(item);_visitables.get("startLogs").remove(builder);if (this.startLogs != null) {this.startLogs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromStartLogs(Predicate<LogEntryBuilder> predicate) {
    if (startLogs == null) return (A) this;
    final Iterator<LogEntryBuilder> each = startLogs.iterator();
    final List visitables = _visitables.get("startLogs");
    while (each.hasNext()) {
      LogEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildStartLogs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LogEntry> getStartLogs() {
    return startLogs != null ? build(startLogs) : null;
  }
  public List<LogEntry> buildStartLogs() {
    return startLogs != null ? build(startLogs) : null;
  }
  public LogEntry buildStartLog(int index) {
    return this.startLogs.get(index).build();
  }
  public LogEntry buildFirstStartLog() {
    return this.startLogs.get(0).build();
  }
  public LogEntry buildLastStartLog() {
    return this.startLogs.get(startLogs.size() - 1).build();
  }
  public LogEntry buildMatchingStartLog(Predicate<LogEntryBuilder> predicate) {
    for (LogEntryBuilder item: startLogs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingStartLog(Predicate<LogEntryBuilder> predicate) {
    for (LogEntryBuilder item: startLogs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withStartLogs(List<LogEntry> startLogs) {
    if (this.startLogs != null) { _visitables.get("startLogs").clear();}
    if (startLogs != null) {this.startLogs = new ArrayList(); for (LogEntry item : startLogs){this.addToStartLogs(item);}} else { this.startLogs = null;} return (A) this;
  }
  public A withStartLogs(io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntry... startLogs) {
    if (this.startLogs != null) {this.startLogs.clear(); _visitables.remove("startLogs"); }
    if (startLogs != null) {for (LogEntry item :startLogs){ this.addToStartLogs(item);}} return (A) this;
  }
  public Boolean hasStartLogs() {
    return startLogs != null && !startLogs.isEmpty();
  }
  public OutageEntryFluentImpl.StartLogsNested<A> addNewStartLog() {
    return new OutageEntryFluentImpl.StartLogsNestedImpl();
  }
  public OutageEntryFluentImpl.StartLogsNested<A> addNewStartLogLike(LogEntry item) {
    return new OutageEntryFluentImpl.StartLogsNestedImpl(-1, item);
  }
  public OutageEntryFluentImpl.StartLogsNested<A> setNewStartLogLike(int index,LogEntry item) {
    return new OutageEntryFluentImpl.StartLogsNestedImpl(index, item);
  }
  public OutageEntryFluentImpl.StartLogsNested<A> editStartLog(int index) {
    if (startLogs.size() <= index) throw new RuntimeException("Can't edit startLogs. Index exceeds size.");
    return setNewStartLogLike(index, buildStartLog(index));
  }
  public OutageEntryFluentImpl.StartLogsNested<A> editFirstStartLog() {
    if (startLogs.size() == 0) throw new RuntimeException("Can't edit first startLogs. The list is empty.");
    return setNewStartLogLike(0, buildStartLog(0));
  }
  public OutageEntryFluentImpl.StartLogsNested<A> editLastStartLog() {
    int index = startLogs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last startLogs. The list is empty.");
    return setNewStartLogLike(index, buildStartLog(index));
  }
  public OutageEntryFluentImpl.StartLogsNested<A> editMatchingStartLog(Predicate<LogEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<startLogs.size();i++) { 
    if (predicate.test(startLogs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching startLogs. No match found.");
    return setNewStartLogLike(index, buildStartLog(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OutageEntryFluentImpl that = (OutageEntryFluentImpl) o;
    if (!java.util.Objects.equals(end, that.end)) return false;

    if (!java.util.Objects.equals(endLogs, that.endLogs)) return false;

    if (!java.util.Objects.equals(message, that.message)) return false;

    if (!java.util.Objects.equals(start, that.start)) return false;

    if (!java.util.Objects.equals(startLogs, that.startLogs)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(end,  endLogs,  message,  start,  startLogs,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (end != null) { sb.append("end:"); sb.append(end + ","); }
    if (endLogs != null && !endLogs.isEmpty()) { sb.append("endLogs:"); sb.append(endLogs + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (start != null) { sb.append("start:"); sb.append(start + ","); }
    if (startLogs != null && !startLogs.isEmpty()) { sb.append("startLogs:"); sb.append(startLogs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class EndLogsNestedImpl<N> extends LogEntryFluentImpl<OutageEntryFluentImpl.EndLogsNested<N>> implements OutageEntryFluentImpl.EndLogsNested<N>,Nested<N>{
    EndLogsNestedImpl(int index,LogEntry item) {
      this.index = index;
      this.builder = new LogEntryBuilder(this, item);
    }
    EndLogsNestedImpl() {
      this.index = -1;
      this.builder = new LogEntryBuilder(this);
    }
    LogEntryBuilder builder;
    int index;
    public N and() {
      return (N) OutageEntryFluentImpl.this.setToEndLogs(index,builder.build());
    }
    public N endEndLog() {
      return and();
    }
    
  }
  class StartLogsNestedImpl<N> extends LogEntryFluentImpl<OutageEntryFluentImpl.StartLogsNested<N>> implements OutageEntryFluentImpl.StartLogsNested<N>,Nested<N>{
    StartLogsNestedImpl(int index,LogEntry item) {
      this.index = index;
      this.builder = new LogEntryBuilder(this, item);
    }
    StartLogsNestedImpl() {
      this.index = -1;
      this.builder = new LogEntryBuilder(this);
    }
    LogEntryBuilder builder;
    int index;
    public N and() {
      return (N) OutageEntryFluentImpl.this.setToStartLogs(index,builder.build());
    }
    public N endStartLog() {
      return and();
    }
    
  }
  
}