package io.fabric8.openshift.api.model.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodNetworkConnectivityCheckConditionBuilder extends PodNetworkConnectivityCheckConditionFluentImpl<PodNetworkConnectivityCheckConditionBuilder> implements VisitableBuilder<PodNetworkConnectivityCheckCondition,PodNetworkConnectivityCheckConditionBuilder>{
  public PodNetworkConnectivityCheckConditionBuilder() {
    this(false);
  }
  public PodNetworkConnectivityCheckConditionBuilder(Boolean validationEnabled) {
    this(new PodNetworkConnectivityCheckCondition(), validationEnabled);
  }
  public PodNetworkConnectivityCheckConditionBuilder(PodNetworkConnectivityCheckConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public PodNetworkConnectivityCheckConditionBuilder(PodNetworkConnectivityCheckConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodNetworkConnectivityCheckCondition(), validationEnabled);
  }
  public PodNetworkConnectivityCheckConditionBuilder(PodNetworkConnectivityCheckConditionFluent<?> fluent,PodNetworkConnectivityCheckCondition instance) {
    this(fluent, instance, false);
  }
  public PodNetworkConnectivityCheckConditionBuilder(PodNetworkConnectivityCheckConditionFluent<?> fluent,PodNetworkConnectivityCheckCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodNetworkConnectivityCheckConditionBuilder(PodNetworkConnectivityCheckCondition instance) {
    this(instance,false);
  }
  public PodNetworkConnectivityCheckConditionBuilder(PodNetworkConnectivityCheckCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodNetworkConnectivityCheckConditionFluent<?> fluent;
  Boolean validationEnabled;
  public PodNetworkConnectivityCheckCondition build() {
    PodNetworkConnectivityCheckCondition buildable = new PodNetworkConnectivityCheckCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}