package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSClassicLoadBalancerParametersBuilder extends AWSClassicLoadBalancerParametersFluentImpl<AWSClassicLoadBalancerParametersBuilder> implements VisitableBuilder<AWSClassicLoadBalancerParameters,AWSClassicLoadBalancerParametersBuilder>{
  public AWSClassicLoadBalancerParametersBuilder() {
    this(false);
  }
  public AWSClassicLoadBalancerParametersBuilder(Boolean validationEnabled) {
    this(new AWSClassicLoadBalancerParameters(), validationEnabled);
  }
  public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParametersFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParametersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSClassicLoadBalancerParameters(), validationEnabled);
  }
  public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParametersFluent<?> fluent,AWSClassicLoadBalancerParameters instance) {
    this(fluent, instance, false);
  }
  public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParametersFluent<?> fluent,AWSClassicLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParameters instance) {
    this(instance,false);
  }
  public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSClassicLoadBalancerParametersFluent<?> fluent;
  Boolean validationEnabled;
  public AWSClassicLoadBalancerParameters build() {
    AWSClassicLoadBalancerParameters buildable = new AWSClassicLoadBalancerParameters();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}