package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSLoadBalancerParametersBuilder extends AWSLoadBalancerParametersFluentImpl<AWSLoadBalancerParametersBuilder> implements VisitableBuilder<AWSLoadBalancerParameters,AWSLoadBalancerParametersBuilder>{
  public AWSLoadBalancerParametersBuilder() {
    this(false);
  }
  public AWSLoadBalancerParametersBuilder(Boolean validationEnabled) {
    this(new AWSLoadBalancerParameters(), validationEnabled);
  }
  public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSLoadBalancerParameters(), validationEnabled);
  }
  public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent,AWSLoadBalancerParameters instance) {
    this(fluent, instance, false);
  }
  public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent,AWSLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClassicLoadBalancer(instance.getClassicLoadBalancer());
      fluent.withNetworkLoadBalancer(instance.getNetworkLoadBalancer());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParameters instance) {
    this(instance,false);
  }
  public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClassicLoadBalancer(instance.getClassicLoadBalancer());
      this.withNetworkLoadBalancer(instance.getNetworkLoadBalancer());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSLoadBalancerParametersFluent<?> fluent;
  Boolean validationEnabled;
  public AWSLoadBalancerParameters build() {
    AWSLoadBalancerParameters buildable = new AWSLoadBalancerParameters(fluent.getClassicLoadBalancer(),fluent.getNetworkLoadBalancer(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}