package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSNetworkLoadBalancerParametersBuilder extends AWSNetworkLoadBalancerParametersFluentImpl<AWSNetworkLoadBalancerParametersBuilder> implements VisitableBuilder<AWSNetworkLoadBalancerParameters,AWSNetworkLoadBalancerParametersBuilder>{
  public AWSNetworkLoadBalancerParametersBuilder() {
    this(false);
  }
  public AWSNetworkLoadBalancerParametersBuilder(Boolean validationEnabled) {
    this(new AWSNetworkLoadBalancerParameters(), validationEnabled);
  }
  public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParametersFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParametersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSNetworkLoadBalancerParameters(), validationEnabled);
  }
  public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParametersFluent<?> fluent,AWSNetworkLoadBalancerParameters instance) {
    this(fluent, instance, false);
  }
  public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParametersFluent<?> fluent,AWSNetworkLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParameters instance) {
    this(instance,false);
  }
  public AWSNetworkLoadBalancerParametersBuilder(AWSNetworkLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSNetworkLoadBalancerParametersFluent<?> fluent;
  Boolean validationEnabled;
  public AWSNetworkLoadBalancerParameters build() {
    AWSNetworkLoadBalancerParameters buildable = new AWSNetworkLoadBalancerParameters();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}