package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AccessLoggingFluentImpl<A extends AccessLoggingFluent<A>> extends BaseFluent<A> implements AccessLoggingFluent<A>{
  public AccessLoggingFluentImpl() {
  }
  public AccessLoggingFluentImpl(AccessLogging instance) {
    if (instance != null) {
      this.withDestination(instance.getDestination());
      this.withHttpCaptureCookies(instance.getHttpCaptureCookies());
      this.withHttpCaptureHeaders(instance.getHttpCaptureHeaders());
      this.withHttpLogFormat(instance.getHttpLogFormat());
      this.withLogEmptyRequests(instance.getLogEmptyRequests());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private LoggingDestinationBuilder destination;
  private ArrayList<IngressControllerCaptureHTTPCookieBuilder> httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
  private IngressControllerCaptureHTTPHeadersBuilder httpCaptureHeaders;
  private String httpLogFormat;
  private String logEmptyRequests;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildDestination instead.
   * @return The buildable object.
   */
  @Deprecated
  public LoggingDestination getDestination() {
    return this.destination!=null ?this.destination.build():null;
  }
  public LoggingDestination buildDestination() {
    return this.destination!=null ?this.destination.build():null;
  }
  public A withDestination(LoggingDestination destination) {
    _visitables.get("destination").remove(this.destination);
    if (destination!=null){ this.destination= new LoggingDestinationBuilder(destination); _visitables.get("destination").add(this.destination);} else { this.destination = null; _visitables.get("destination").remove(this.destination); } return (A) this;
  }
  public Boolean hasDestination() {
    return this.destination != null;
  }
  public AccessLoggingFluentImpl.DestinationNested<A> withNewDestination() {
    return new AccessLoggingFluentImpl.DestinationNestedImpl();
  }
  public AccessLoggingFluentImpl.DestinationNested<A> withNewDestinationLike(LoggingDestination item) {
    return new AccessLoggingFluentImpl.DestinationNestedImpl(item);
  }
  public AccessLoggingFluentImpl.DestinationNested<A> editDestination() {
    return withNewDestinationLike(getDestination());
  }
  public AccessLoggingFluentImpl.DestinationNested<A> editOrNewDestination() {
    return withNewDestinationLike(getDestination() != null ? getDestination(): new LoggingDestinationBuilder().build());
  }
  public AccessLoggingFluentImpl.DestinationNested<A> editOrNewDestinationLike(LoggingDestination item) {
    return withNewDestinationLike(getDestination() != null ? getDestination(): item);
  }
  public A addToHttpCaptureCookies(int index,IngressControllerCaptureHTTPCookie item) {
    if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();}
    IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
    if (index < 0 || index >= httpCaptureCookies.size()) { _visitables.get("httpCaptureCookies").add(builder); httpCaptureCookies.add(builder); } else { _visitables.get("httpCaptureCookies").add(index, builder); httpCaptureCookies.add(index, builder);}
    return (A)this;
  }
  public A setToHttpCaptureCookies(int index,IngressControllerCaptureHTTPCookie item) {
    if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();}
    IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
    if (index < 0 || index >= httpCaptureCookies.size()) { _visitables.get("httpCaptureCookies").add(builder); httpCaptureCookies.add(builder); } else { _visitables.get("httpCaptureCookies").set(index, builder); httpCaptureCookies.set(index, builder);}
    return (A)this;
  }
  public A addToHttpCaptureCookies(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie... items) {
    if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();}
    for (IngressControllerCaptureHTTPCookie item : items) {IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").add(builder);this.httpCaptureCookies.add(builder);} return (A)this;
  }
  public A addAllToHttpCaptureCookies(Collection<IngressControllerCaptureHTTPCookie> items) {
    if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();}
    for (IngressControllerCaptureHTTPCookie item : items) {IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").add(builder);this.httpCaptureCookies.add(builder);} return (A)this;
  }
  public A removeFromHttpCaptureCookies(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie... items) {
    for (IngressControllerCaptureHTTPCookie item : items) {IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").remove(builder);if (this.httpCaptureCookies != null) {this.httpCaptureCookies.remove(builder);}} return (A)this;
  }
  public A removeAllFromHttpCaptureCookies(Collection<IngressControllerCaptureHTTPCookie> items) {
    for (IngressControllerCaptureHTTPCookie item : items) {IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").remove(builder);if (this.httpCaptureCookies != null) {this.httpCaptureCookies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHttpCaptureCookies(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
    if (httpCaptureCookies == null) return (A) this;
    final Iterator<IngressControllerCaptureHTTPCookieBuilder> each = httpCaptureCookies.iterator();
    final List visitables = _visitables.get("httpCaptureCookies");
    while (each.hasNext()) {
      IngressControllerCaptureHTTPCookieBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHttpCaptureCookies instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IngressControllerCaptureHTTPCookie> getHttpCaptureCookies() {
    return httpCaptureCookies != null ? build(httpCaptureCookies) : null;
  }
  public List<IngressControllerCaptureHTTPCookie> buildHttpCaptureCookies() {
    return httpCaptureCookies != null ? build(httpCaptureCookies) : null;
  }
  public IngressControllerCaptureHTTPCookie buildHttpCaptureCooky(int index) {
    return this.httpCaptureCookies.get(index).build();
  }
  public IngressControllerCaptureHTTPCookie buildFirstHttpCaptureCooky() {
    return this.httpCaptureCookies.get(0).build();
  }
  public IngressControllerCaptureHTTPCookie buildLastHttpCaptureCooky() {
    return this.httpCaptureCookies.get(httpCaptureCookies.size() - 1).build();
  }
  public IngressControllerCaptureHTTPCookie buildMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
    for (IngressControllerCaptureHTTPCookieBuilder item: httpCaptureCookies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
    for (IngressControllerCaptureHTTPCookieBuilder item: httpCaptureCookies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHttpCaptureCookies(List<IngressControllerCaptureHTTPCookie> httpCaptureCookies) {
    if (this.httpCaptureCookies != null) { _visitables.get("httpCaptureCookies").clear();}
    if (httpCaptureCookies != null) {this.httpCaptureCookies = new ArrayList(); for (IngressControllerCaptureHTTPCookie item : httpCaptureCookies){this.addToHttpCaptureCookies(item);}} else { this.httpCaptureCookies = null;} return (A) this;
  }
  public A withHttpCaptureCookies(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie... httpCaptureCookies) {
    if (this.httpCaptureCookies != null) {this.httpCaptureCookies.clear(); _visitables.remove("httpCaptureCookies"); }
    if (httpCaptureCookies != null) {for (IngressControllerCaptureHTTPCookie item :httpCaptureCookies){ this.addToHttpCaptureCookies(item);}} return (A) this;
  }
  public Boolean hasHttpCaptureCookies() {
    return httpCaptureCookies != null && !httpCaptureCookies.isEmpty();
  }
  public A addNewHttpCaptureCooky(String matchType,Integer maxLength,String name,String namePrefix) {
    return (A)addToHttpCaptureCookies(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
  }
  public AccessLoggingFluentImpl.HttpCaptureCookiesNested<A> addNewHttpCaptureCooky() {
    return new AccessLoggingFluentImpl.HttpCaptureCookiesNestedImpl();
  }
  public AccessLoggingFluentImpl.HttpCaptureCookiesNested<A> addNewHttpCaptureCookyLike(IngressControllerCaptureHTTPCookie item) {
    return new AccessLoggingFluentImpl.HttpCaptureCookiesNestedImpl(-1, item);
  }
  public AccessLoggingFluentImpl.HttpCaptureCookiesNested<A> setNewHttpCaptureCookyLike(int index,IngressControllerCaptureHTTPCookie item) {
    return new AccessLoggingFluentImpl.HttpCaptureCookiesNestedImpl(index, item);
  }
  public AccessLoggingFluentImpl.HttpCaptureCookiesNested<A> editHttpCaptureCooky(int index) {
    if (httpCaptureCookies.size() <= index) throw new RuntimeException("Can't edit httpCaptureCookies. Index exceeds size.");
    return setNewHttpCaptureCookyLike(index, buildHttpCaptureCooky(index));
  }
  public AccessLoggingFluentImpl.HttpCaptureCookiesNested<A> editFirstHttpCaptureCooky() {
    if (httpCaptureCookies.size() == 0) throw new RuntimeException("Can't edit first httpCaptureCookies. The list is empty.");
    return setNewHttpCaptureCookyLike(0, buildHttpCaptureCooky(0));
  }
  public AccessLoggingFluentImpl.HttpCaptureCookiesNested<A> editLastHttpCaptureCooky() {
    int index = httpCaptureCookies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last httpCaptureCookies. The list is empty.");
    return setNewHttpCaptureCookyLike(index, buildHttpCaptureCooky(index));
  }
  public AccessLoggingFluentImpl.HttpCaptureCookiesNested<A> editMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
    int index = -1;
    for (int i=0;i<httpCaptureCookies.size();i++) { 
    if (predicate.test(httpCaptureCookies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching httpCaptureCookies. No match found.");
    return setNewHttpCaptureCookyLike(index, buildHttpCaptureCooky(index));
  }
  
  /**
   * This method has been deprecated, please use method buildHttpCaptureHeaders instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressControllerCaptureHTTPHeaders getHttpCaptureHeaders() {
    return this.httpCaptureHeaders!=null ?this.httpCaptureHeaders.build():null;
  }
  public IngressControllerCaptureHTTPHeaders buildHttpCaptureHeaders() {
    return this.httpCaptureHeaders!=null ?this.httpCaptureHeaders.build():null;
  }
  public A withHttpCaptureHeaders(IngressControllerCaptureHTTPHeaders httpCaptureHeaders) {
    _visitables.get("httpCaptureHeaders").remove(this.httpCaptureHeaders);
    if (httpCaptureHeaders!=null){ this.httpCaptureHeaders= new IngressControllerCaptureHTTPHeadersBuilder(httpCaptureHeaders); _visitables.get("httpCaptureHeaders").add(this.httpCaptureHeaders);} else { this.httpCaptureHeaders = null; _visitables.get("httpCaptureHeaders").remove(this.httpCaptureHeaders); } return (A) this;
  }
  public Boolean hasHttpCaptureHeaders() {
    return this.httpCaptureHeaders != null;
  }
  public AccessLoggingFluentImpl.HttpCaptureHeadersNested<A> withNewHttpCaptureHeaders() {
    return new AccessLoggingFluentImpl.HttpCaptureHeadersNestedImpl();
  }
  public AccessLoggingFluentImpl.HttpCaptureHeadersNested<A> withNewHttpCaptureHeadersLike(IngressControllerCaptureHTTPHeaders item) {
    return new AccessLoggingFluentImpl.HttpCaptureHeadersNestedImpl(item);
  }
  public AccessLoggingFluentImpl.HttpCaptureHeadersNested<A> editHttpCaptureHeaders() {
    return withNewHttpCaptureHeadersLike(getHttpCaptureHeaders());
  }
  public AccessLoggingFluentImpl.HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeaders() {
    return withNewHttpCaptureHeadersLike(getHttpCaptureHeaders() != null ? getHttpCaptureHeaders(): new IngressControllerCaptureHTTPHeadersBuilder().build());
  }
  public AccessLoggingFluentImpl.HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeadersLike(IngressControllerCaptureHTTPHeaders item) {
    return withNewHttpCaptureHeadersLike(getHttpCaptureHeaders() != null ? getHttpCaptureHeaders(): item);
  }
  public String getHttpLogFormat() {
    return this.httpLogFormat;
  }
  public A withHttpLogFormat(String httpLogFormat) {
    this.httpLogFormat=httpLogFormat; return (A) this;
  }
  public Boolean hasHttpLogFormat() {
    return this.httpLogFormat != null;
  }
  public String getLogEmptyRequests() {
    return this.logEmptyRequests;
  }
  public A withLogEmptyRequests(String logEmptyRequests) {
    this.logEmptyRequests=logEmptyRequests; return (A) this;
  }
  public Boolean hasLogEmptyRequests() {
    return this.logEmptyRequests != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AccessLoggingFluentImpl that = (AccessLoggingFluentImpl) o;
    if (!java.util.Objects.equals(destination, that.destination)) return false;

    if (!java.util.Objects.equals(httpCaptureCookies, that.httpCaptureCookies)) return false;

    if (!java.util.Objects.equals(httpCaptureHeaders, that.httpCaptureHeaders)) return false;

    if (!java.util.Objects.equals(httpLogFormat, that.httpLogFormat)) return false;

    if (!java.util.Objects.equals(logEmptyRequests, that.logEmptyRequests)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(destination,  httpCaptureCookies,  httpCaptureHeaders,  httpLogFormat,  logEmptyRequests,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (destination != null) { sb.append("destination:"); sb.append(destination + ","); }
    if (httpCaptureCookies != null && !httpCaptureCookies.isEmpty()) { sb.append("httpCaptureCookies:"); sb.append(httpCaptureCookies + ","); }
    if (httpCaptureHeaders != null) { sb.append("httpCaptureHeaders:"); sb.append(httpCaptureHeaders + ","); }
    if (httpLogFormat != null) { sb.append("httpLogFormat:"); sb.append(httpLogFormat + ","); }
    if (logEmptyRequests != null) { sb.append("logEmptyRequests:"); sb.append(logEmptyRequests + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DestinationNestedImpl<N> extends LoggingDestinationFluentImpl<AccessLoggingFluentImpl.DestinationNested<N>> implements AccessLoggingFluentImpl.DestinationNested<N>,Nested<N>{
    DestinationNestedImpl(LoggingDestination item) {
      this.builder = new LoggingDestinationBuilder(this, item);
    }
    DestinationNestedImpl() {
      this.builder = new LoggingDestinationBuilder(this);
    }
    LoggingDestinationBuilder builder;
    public N and() {
      return (N) AccessLoggingFluentImpl.this.withDestination(builder.build());
    }
    public N endDestination() {
      return and();
    }
    
  }
  class HttpCaptureCookiesNestedImpl<N> extends IngressControllerCaptureHTTPCookieFluentImpl<AccessLoggingFluentImpl.HttpCaptureCookiesNested<N>> implements AccessLoggingFluentImpl.HttpCaptureCookiesNested<N>,Nested<N>{
    HttpCaptureCookiesNestedImpl(int index,IngressControllerCaptureHTTPCookie item) {
      this.index = index;
      this.builder = new IngressControllerCaptureHTTPCookieBuilder(this, item);
    }
    HttpCaptureCookiesNestedImpl() {
      this.index = -1;
      this.builder = new IngressControllerCaptureHTTPCookieBuilder(this);
    }
    IngressControllerCaptureHTTPCookieBuilder builder;
    int index;
    public N and() {
      return (N) AccessLoggingFluentImpl.this.setToHttpCaptureCookies(index,builder.build());
    }
    public N endHttpCaptureCooky() {
      return and();
    }
    
  }
  class HttpCaptureHeadersNestedImpl<N> extends IngressControllerCaptureHTTPHeadersFluentImpl<AccessLoggingFluentImpl.HttpCaptureHeadersNested<N>> implements AccessLoggingFluentImpl.HttpCaptureHeadersNested<N>,Nested<N>{
    HttpCaptureHeadersNestedImpl(IngressControllerCaptureHTTPHeaders item) {
      this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this, item);
    }
    HttpCaptureHeadersNestedImpl() {
      this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this);
    }
    IngressControllerCaptureHTTPHeadersBuilder builder;
    public N and() {
      return (N) AccessLoggingFluentImpl.this.withHttpCaptureHeaders(builder.build());
    }
    public N endHttpCaptureHeaders() {
      return and();
    }
    
  }
  
}