package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthenticationSpecBuilder extends AuthenticationSpecFluentImpl<AuthenticationSpecBuilder> implements VisitableBuilder<AuthenticationSpec,AuthenticationSpecBuilder>{
  public AuthenticationSpecBuilder() {
    this(false);
  }
  public AuthenticationSpecBuilder(Boolean validationEnabled) {
    this(new AuthenticationSpec(), validationEnabled);
  }
  public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AuthenticationSpec(), validationEnabled);
  }
  public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent,AuthenticationSpec instance) {
    this(fluent, instance, false);
  }
  public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent,AuthenticationSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AuthenticationSpecBuilder(AuthenticationSpec instance) {
    this(instance,false);
  }
  public AuthenticationSpecBuilder(AuthenticationSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AuthenticationSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AuthenticationSpec build() {
    AuthenticationSpec buildable = new AuthenticationSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}