package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClientTLSFluentImpl<A extends ClientTLSFluent<A>> extends BaseFluent<A> implements ClientTLSFluent<A>{
  public ClientTLSFluentImpl() {
  }
  public ClientTLSFluentImpl(ClientTLS instance) {
    if (instance != null) {
      this.withAllowedSubjectPatterns(instance.getAllowedSubjectPatterns());
      this.withClientCA(instance.getClientCA());
      this.withClientCertificatePolicy(instance.getClientCertificatePolicy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> allowedSubjectPatterns = new ArrayList<String>();
  private ConfigMapNameReference clientCA;
  private String clientCertificatePolicy;
  private Map<String,Object> additionalProperties;
  public A addToAllowedSubjectPatterns(int index,String item) {
    if (this.allowedSubjectPatterns == null) {this.allowedSubjectPatterns = new ArrayList<String>();}
    this.allowedSubjectPatterns.add(index, item);
    return (A)this;
  }
  public A setToAllowedSubjectPatterns(int index,String item) {
    if (this.allowedSubjectPatterns == null) {this.allowedSubjectPatterns = new ArrayList<String>();}
    this.allowedSubjectPatterns.set(index, item); return (A)this;
  }
  public A addToAllowedSubjectPatterns(java.lang.String... items) {
    if (this.allowedSubjectPatterns == null) {this.allowedSubjectPatterns = new ArrayList<String>();}
    for (String item : items) {this.allowedSubjectPatterns.add(item);} return (A)this;
  }
  public A addAllToAllowedSubjectPatterns(Collection<String> items) {
    if (this.allowedSubjectPatterns == null) {this.allowedSubjectPatterns = new ArrayList<String>();}
    for (String item : items) {this.allowedSubjectPatterns.add(item);} return (A)this;
  }
  public A removeFromAllowedSubjectPatterns(java.lang.String... items) {
    for (String item : items) {if (this.allowedSubjectPatterns!= null){ this.allowedSubjectPatterns.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedSubjectPatterns(Collection<String> items) {
    for (String item : items) {if (this.allowedSubjectPatterns!= null){ this.allowedSubjectPatterns.remove(item);}} return (A)this;
  }
  public List<String> getAllowedSubjectPatterns() {
    return this.allowedSubjectPatterns;
  }
  public String getAllowedSubjectPattern(int index) {
    return this.allowedSubjectPatterns.get(index);
  }
  public String getFirstAllowedSubjectPattern() {
    return this.allowedSubjectPatterns.get(0);
  }
  public String getLastAllowedSubjectPattern() {
    return this.allowedSubjectPatterns.get(allowedSubjectPatterns.size() - 1);
  }
  public String getMatchingAllowedSubjectPattern(Predicate<String> predicate) {
    for (String item: allowedSubjectPatterns) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAllowedSubjectPattern(Predicate<String> predicate) {
    for (String item: allowedSubjectPatterns) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedSubjectPatterns(List<String> allowedSubjectPatterns) {
    if (allowedSubjectPatterns != null) {this.allowedSubjectPatterns = new ArrayList(); for (String item : allowedSubjectPatterns){this.addToAllowedSubjectPatterns(item);}} else { this.allowedSubjectPatterns = null;} return (A) this;
  }
  public A withAllowedSubjectPatterns(java.lang.String... allowedSubjectPatterns) {
    if (this.allowedSubjectPatterns != null) {this.allowedSubjectPatterns.clear(); _visitables.remove("allowedSubjectPatterns"); }
    if (allowedSubjectPatterns != null) {for (String item :allowedSubjectPatterns){ this.addToAllowedSubjectPatterns(item);}} return (A) this;
  }
  public Boolean hasAllowedSubjectPatterns() {
    return allowedSubjectPatterns != null && !allowedSubjectPatterns.isEmpty();
  }
  public ConfigMapNameReference getClientCA() {
    return this.clientCA;
  }
  public A withClientCA(ConfigMapNameReference clientCA) {
    this.clientCA=clientCA; return (A) this;
  }
  public Boolean hasClientCA() {
    return this.clientCA != null;
  }
  public A withNewClientCA(String name) {
    return (A)withClientCA(new ConfigMapNameReference(name));
  }
  public String getClientCertificatePolicy() {
    return this.clientCertificatePolicy;
  }
  public A withClientCertificatePolicy(String clientCertificatePolicy) {
    this.clientCertificatePolicy=clientCertificatePolicy; return (A) this;
  }
  public Boolean hasClientCertificatePolicy() {
    return this.clientCertificatePolicy != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClientTLSFluentImpl that = (ClientTLSFluentImpl) o;
    if (!java.util.Objects.equals(allowedSubjectPatterns, that.allowedSubjectPatterns)) return false;

    if (!java.util.Objects.equals(clientCA, that.clientCA)) return false;

    if (!java.util.Objects.equals(clientCertificatePolicy, that.clientCertificatePolicy)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowedSubjectPatterns,  clientCA,  clientCertificatePolicy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowedSubjectPatterns != null && !allowedSubjectPatterns.isEmpty()) { sb.append("allowedSubjectPatterns:"); sb.append(allowedSubjectPatterns + ","); }
    if (clientCA != null) { sb.append("clientCA:"); sb.append(clientCA + ","); }
    if (clientCertificatePolicy != null) { sb.append("clientCertificatePolicy:"); sb.append(clientCertificatePolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}