package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterCSIDriverListBuilder extends ClusterCSIDriverListFluentImpl<ClusterCSIDriverListBuilder> implements VisitableBuilder<ClusterCSIDriverList,ClusterCSIDriverListBuilder>{
  public ClusterCSIDriverListBuilder() {
    this(false);
  }
  public ClusterCSIDriverListBuilder(Boolean validationEnabled) {
    this(new ClusterCSIDriverList(), validationEnabled);
  }
  public ClusterCSIDriverListBuilder(ClusterCSIDriverListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterCSIDriverListBuilder(ClusterCSIDriverListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterCSIDriverList(), validationEnabled);
  }
  public ClusterCSIDriverListBuilder(ClusterCSIDriverListFluent<?> fluent,ClusterCSIDriverList instance) {
    this(fluent, instance, false);
  }
  public ClusterCSIDriverListBuilder(ClusterCSIDriverListFluent<?> fluent,ClusterCSIDriverList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterCSIDriverListBuilder(ClusterCSIDriverList instance) {
    this(instance,false);
  }
  public ClusterCSIDriverListBuilder(ClusterCSIDriverList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterCSIDriverListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterCSIDriverList build() {
    ClusterCSIDriverList buildable = new ClusterCSIDriverList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}