package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigStatusBuilder extends ConfigStatusFluentImpl<ConfigStatusBuilder> implements VisitableBuilder<ConfigStatus,ConfigStatusBuilder>{
  public ConfigStatusBuilder() {
    this(false);
  }
  public ConfigStatusBuilder(Boolean validationEnabled) {
    this(new ConfigStatus(), validationEnabled);
  }
  public ConfigStatusBuilder(ConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigStatusBuilder(ConfigStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigStatus(), validationEnabled);
  }
  public ConfigStatusBuilder(ConfigStatusFluent<?> fluent,ConfigStatus instance) {
    this(fluent, instance, false);
  }
  public ConfigStatusBuilder(ConfigStatusFluent<?> fluent,ConfigStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigStatusBuilder(ConfigStatus instance) {
    this(instance,false);
  }
  public ConfigStatusBuilder(ConfigStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigStatus build() {
    ConfigStatus buildable = new ConfigStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}