package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleListBuilder extends ConsoleListFluentImpl<ConsoleListBuilder> implements VisitableBuilder<ConsoleList,ConsoleListBuilder>{
  public ConsoleListBuilder() {
    this(false);
  }
  public ConsoleListBuilder(Boolean validationEnabled) {
    this(new ConsoleList(), validationEnabled);
  }
  public ConsoleListBuilder(ConsoleListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleListBuilder(ConsoleListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleList(), validationEnabled);
  }
  public ConsoleListBuilder(ConsoleListFluent<?> fluent,ConsoleList instance) {
    this(fluent, instance, false);
  }
  public ConsoleListBuilder(ConsoleListFluent<?> fluent,ConsoleList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleListBuilder(ConsoleList instance) {
    this(instance,false);
  }
  public ConsoleListBuilder(ConsoleList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleListFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleList build() {
    ConsoleList buildable = new ConsoleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}