package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleProvidersBuilder extends ConsoleProvidersFluentImpl<ConsoleProvidersBuilder> implements VisitableBuilder<ConsoleProviders,ConsoleProvidersBuilder>{
  public ConsoleProvidersBuilder() {
    this(false);
  }
  public ConsoleProvidersBuilder(Boolean validationEnabled) {
    this(new ConsoleProviders(), validationEnabled);
  }
  public ConsoleProvidersBuilder(ConsoleProvidersFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleProvidersBuilder(ConsoleProvidersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleProviders(), validationEnabled);
  }
  public ConsoleProvidersBuilder(ConsoleProvidersFluent<?> fluent,ConsoleProviders instance) {
    this(fluent, instance, false);
  }
  public ConsoleProvidersBuilder(ConsoleProvidersFluent<?> fluent,ConsoleProviders instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withStatuspage(instance.getStatuspage());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleProvidersBuilder(ConsoleProviders instance) {
    this(instance,false);
  }
  public ConsoleProvidersBuilder(ConsoleProviders instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withStatuspage(instance.getStatuspage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleProvidersFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleProviders build() {
    ConsoleProviders buildable = new ConsoleProviders(fluent.getStatuspage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}