package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSBuilder extends DNSFluentImpl<DNSBuilder> implements VisitableBuilder<DNS,DNSBuilder>{
  public DNSBuilder() {
    this(false);
  }
  public DNSBuilder(Boolean validationEnabled) {
    this(new DNS(), validationEnabled);
  }
  public DNSBuilder(DNSFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSBuilder(DNSFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNS(), validationEnabled);
  }
  public DNSBuilder(DNSFluent<?> fluent,DNS instance) {
    this(fluent, instance, false);
  }
  public DNSBuilder(DNSFluent<?> fluent,DNS instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSBuilder(DNS instance) {
    this(instance,false);
  }
  public DNSBuilder(DNS instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSFluent<?> fluent;
  Boolean validationEnabled;
  public DNS build() {
    DNS buildable = new DNS(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}