package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSRecordBuilder extends DNSRecordFluentImpl<DNSRecordBuilder> implements VisitableBuilder<DNSRecord,DNSRecordBuilder>{
  public DNSRecordBuilder() {
    this(false);
  }
  public DNSRecordBuilder(Boolean validationEnabled) {
    this(new DNSRecord(), validationEnabled);
  }
  public DNSRecordBuilder(DNSRecordFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSRecordBuilder(DNSRecordFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSRecord(), validationEnabled);
  }
  public DNSRecordBuilder(DNSRecordFluent<?> fluent,DNSRecord instance) {
    this(fluent, instance, false);
  }
  public DNSRecordBuilder(DNSRecordFluent<?> fluent,DNSRecord instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSRecordBuilder(DNSRecord instance) {
    this(instance,false);
  }
  public DNSRecordBuilder(DNSRecord instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSRecordFluent<?> fluent;
  Boolean validationEnabled;
  public DNSRecord build() {
    DNSRecord buildable = new DNSRecord(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}