package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DNSRecordStatusFluentImpl<A extends DNSRecordStatusFluent<A>> extends BaseFluent<A> implements DNSRecordStatusFluent<A>{
  public DNSRecordStatusFluentImpl() {
  }
  public DNSRecordStatusFluentImpl(DNSRecordStatus instance) {
    if (instance != null) {
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withZones(instance.getZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Long observedGeneration;
  private ArrayList<DNSZoneStatusBuilder> zones = new ArrayList<DNSZoneStatusBuilder>();
  private Map<String,Object> additionalProperties;
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToZones(int index,DNSZoneStatus item) {
    if (this.zones == null) {this.zones = new ArrayList<DNSZoneStatusBuilder>();}
    DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
    if (index < 0 || index >= zones.size()) { _visitables.get("zones").add(builder); zones.add(builder); } else { _visitables.get("zones").add(index, builder); zones.add(index, builder);}
    return (A)this;
  }
  public A setToZones(int index,DNSZoneStatus item) {
    if (this.zones == null) {this.zones = new ArrayList<DNSZoneStatusBuilder>();}
    DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
    if (index < 0 || index >= zones.size()) { _visitables.get("zones").add(builder); zones.add(builder); } else { _visitables.get("zones").set(index, builder); zones.set(index, builder);}
    return (A)this;
  }
  public A addToZones(io.fabric8.openshift.api.model.operator.v1.DNSZoneStatus... items) {
    if (this.zones == null) {this.zones = new ArrayList<DNSZoneStatusBuilder>();}
    for (DNSZoneStatus item : items) {DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);_visitables.get("zones").add(builder);this.zones.add(builder);} return (A)this;
  }
  public A addAllToZones(Collection<DNSZoneStatus> items) {
    if (this.zones == null) {this.zones = new ArrayList<DNSZoneStatusBuilder>();}
    for (DNSZoneStatus item : items) {DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);_visitables.get("zones").add(builder);this.zones.add(builder);} return (A)this;
  }
  public A removeFromZones(io.fabric8.openshift.api.model.operator.v1.DNSZoneStatus... items) {
    for (DNSZoneStatus item : items) {DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);_visitables.get("zones").remove(builder);if (this.zones != null) {this.zones.remove(builder);}} return (A)this;
  }
  public A removeAllFromZones(Collection<DNSZoneStatus> items) {
    for (DNSZoneStatus item : items) {DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);_visitables.get("zones").remove(builder);if (this.zones != null) {this.zones.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromZones(Predicate<DNSZoneStatusBuilder> predicate) {
    if (zones == null) return (A) this;
    final Iterator<DNSZoneStatusBuilder> each = zones.iterator();
    final List visitables = _visitables.get("zones");
    while (each.hasNext()) {
      DNSZoneStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildZones instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DNSZoneStatus> getZones() {
    return zones != null ? build(zones) : null;
  }
  public List<DNSZoneStatus> buildZones() {
    return zones != null ? build(zones) : null;
  }
  public DNSZoneStatus buildZone(int index) {
    return this.zones.get(index).build();
  }
  public DNSZoneStatus buildFirstZone() {
    return this.zones.get(0).build();
  }
  public DNSZoneStatus buildLastZone() {
    return this.zones.get(zones.size() - 1).build();
  }
  public DNSZoneStatus buildMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
    for (DNSZoneStatusBuilder item: zones) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
    for (DNSZoneStatusBuilder item: zones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withZones(List<DNSZoneStatus> zones) {
    if (this.zones != null) { _visitables.get("zones").clear();}
    if (zones != null) {this.zones = new ArrayList(); for (DNSZoneStatus item : zones){this.addToZones(item);}} else { this.zones = null;} return (A) this;
  }
  public A withZones(io.fabric8.openshift.api.model.operator.v1.DNSZoneStatus... zones) {
    if (this.zones != null) {this.zones.clear(); _visitables.remove("zones"); }
    if (zones != null) {for (DNSZoneStatus item :zones){ this.addToZones(item);}} return (A) this;
  }
  public Boolean hasZones() {
    return zones != null && !zones.isEmpty();
  }
  public DNSRecordStatusFluentImpl.ZonesNested<A> addNewZone() {
    return new DNSRecordStatusFluentImpl.ZonesNestedImpl();
  }
  public DNSRecordStatusFluentImpl.ZonesNested<A> addNewZoneLike(DNSZoneStatus item) {
    return new DNSRecordStatusFluentImpl.ZonesNestedImpl(-1, item);
  }
  public DNSRecordStatusFluentImpl.ZonesNested<A> setNewZoneLike(int index,DNSZoneStatus item) {
    return new DNSRecordStatusFluentImpl.ZonesNestedImpl(index, item);
  }
  public DNSRecordStatusFluentImpl.ZonesNested<A> editZone(int index) {
    if (zones.size() <= index) throw new RuntimeException("Can't edit zones. Index exceeds size.");
    return setNewZoneLike(index, buildZone(index));
  }
  public DNSRecordStatusFluentImpl.ZonesNested<A> editFirstZone() {
    if (zones.size() == 0) throw new RuntimeException("Can't edit first zones. The list is empty.");
    return setNewZoneLike(0, buildZone(0));
  }
  public DNSRecordStatusFluentImpl.ZonesNested<A> editLastZone() {
    int index = zones.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last zones. The list is empty.");
    return setNewZoneLike(index, buildZone(index));
  }
  public DNSRecordStatusFluentImpl.ZonesNested<A> editMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<zones.size();i++) { 
    if (predicate.test(zones.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching zones. No match found.");
    return setNewZoneLike(index, buildZone(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSRecordStatusFluentImpl that = (DNSRecordStatusFluentImpl) o;
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(zones, that.zones)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(observedGeneration,  zones,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ZonesNestedImpl<N> extends DNSZoneStatusFluentImpl<DNSRecordStatusFluentImpl.ZonesNested<N>> implements DNSRecordStatusFluentImpl.ZonesNested<N>,Nested<N>{
    ZonesNestedImpl(int index,DNSZoneStatus item) {
      this.index = index;
      this.builder = new DNSZoneStatusBuilder(this, item);
    }
    ZonesNestedImpl() {
      this.index = -1;
      this.builder = new DNSZoneStatusBuilder(this);
    }
    DNSZoneStatusBuilder builder;
    int index;
    public N and() {
      return (N) DNSRecordStatusFluentImpl.this.setToZones(index,builder.build());
    }
    public N endZone() {
      return and();
    }
    
  }
  
}