package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSSpecBuilder extends DNSSpecFluentImpl<DNSSpecBuilder> implements VisitableBuilder<DNSSpec,DNSSpecBuilder>{
  public DNSSpecBuilder() {
    this(false);
  }
  public DNSSpecBuilder(Boolean validationEnabled) {
    this(new DNSSpec(), validationEnabled);
  }
  public DNSSpecBuilder(DNSSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSSpecBuilder(DNSSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSSpec(), validationEnabled);
  }
  public DNSSpecBuilder(DNSSpecFluent<?> fluent,DNSSpec instance) {
    this(fluent, instance, false);
  }
  public DNSSpecBuilder(DNSSpecFluent<?> fluent,DNSSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withNodePlacement(instance.getNodePlacement());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withServers(instance.getServers());
      fluent.withUpstreamResolvers(instance.getUpstreamResolvers());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSSpecBuilder(DNSSpec instance) {
    this(instance,false);
  }
  public DNSSpecBuilder(DNSSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withNodePlacement(instance.getNodePlacement());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withServers(instance.getServers());
      this.withUpstreamResolvers(instance.getUpstreamResolvers());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DNSSpec build() {
    DNSSpec buildable = new DNSSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getNodePlacement(),fluent.getOperatorLogLevel(),fluent.getServers(),fluent.getUpstreamResolvers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}