package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface DNSSpecFluent<A extends DNSSpecFluent<A>> extends Fluent<A>{
  public String getLogLevel();
  public A withLogLevel(String logLevel);
  public Boolean hasLogLevel();
  public String getManagementState();
  public A withManagementState(String managementState);
  public Boolean hasManagementState();
  
  /**
   * This method has been deprecated, please use method buildNodePlacement instead.
   * @return The buildable object.
   */
  @Deprecated
  public DNSNodePlacement getNodePlacement();
  public DNSNodePlacement buildNodePlacement();
  public A withNodePlacement(DNSNodePlacement nodePlacement);
  public Boolean hasNodePlacement();
  public DNSSpecFluent.NodePlacementNested<A> withNewNodePlacement();
  public DNSSpecFluent.NodePlacementNested<A> withNewNodePlacementLike(DNSNodePlacement item);
  public DNSSpecFluent.NodePlacementNested<A> editNodePlacement();
  public DNSSpecFluent.NodePlacementNested<A> editOrNewNodePlacement();
  public DNSSpecFluent.NodePlacementNested<A> editOrNewNodePlacementLike(DNSNodePlacement item);
  public String getOperatorLogLevel();
  public A withOperatorLogLevel(String operatorLogLevel);
  public Boolean hasOperatorLogLevel();
  public A addToServers(int index,Server item);
  public A setToServers(int index,Server item);
  public A addToServers(io.fabric8.openshift.api.model.operator.v1.Server... items);
  public A addAllToServers(Collection<Server> items);
  public A removeFromServers(io.fabric8.openshift.api.model.operator.v1.Server... items);
  public A removeAllFromServers(Collection<Server> items);
  public A removeMatchingFromServers(Predicate<ServerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildServers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Server> getServers();
  public List<Server> buildServers();
  public Server buildServer(int index);
  public Server buildFirstServer();
  public Server buildLastServer();
  public Server buildMatchingServer(Predicate<ServerBuilder> predicate);
  public Boolean hasMatchingServer(Predicate<ServerBuilder> predicate);
  public A withServers(List<Server> servers);
  public A withServers(io.fabric8.openshift.api.model.operator.v1.Server... servers);
  public Boolean hasServers();
  public DNSSpecFluent.ServersNested<A> addNewServer();
  public DNSSpecFluent.ServersNested<A> addNewServerLike(Server item);
  public DNSSpecFluent.ServersNested<A> setNewServerLike(int index,Server item);
  public DNSSpecFluent.ServersNested<A> editServer(int index);
  public DNSSpecFluent.ServersNested<A> editFirstServer();
  public DNSSpecFluent.ServersNested<A> editLastServer();
  public DNSSpecFluent.ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildUpstreamResolvers instead.
   * @return The buildable object.
   */
  @Deprecated
  public UpstreamResolvers getUpstreamResolvers();
  public UpstreamResolvers buildUpstreamResolvers();
  public A withUpstreamResolvers(UpstreamResolvers upstreamResolvers);
  public Boolean hasUpstreamResolvers();
  public DNSSpecFluent.UpstreamResolversNested<A> withNewUpstreamResolvers();
  public DNSSpecFluent.UpstreamResolversNested<A> withNewUpstreamResolversLike(UpstreamResolvers item);
  public DNSSpecFluent.UpstreamResolversNested<A> editUpstreamResolvers();
  public DNSSpecFluent.UpstreamResolversNested<A> editOrNewUpstreamResolvers();
  public DNSSpecFluent.UpstreamResolversNested<A> editOrNewUpstreamResolversLike(UpstreamResolvers item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface NodePlacementNested<N> extends Nested<N>,DNSNodePlacementFluent<DNSSpecFluent.NodePlacementNested<N>>{
    public N and();
    public N endNodePlacement();
    
  }
  public interface ServersNested<N> extends Nested<N>,ServerFluent<DNSSpecFluent.ServersNested<N>>{
    public N and();
    public N endServer();
    
  }
  public interface UpstreamResolversNested<N> extends Nested<N>,UpstreamResolversFluent<DNSSpecFluent.UpstreamResolversNested<N>>{
    public N and();
    public N endUpstreamResolvers();
    
  }
  
}