package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DNSSpecFluentImpl<A extends DNSSpecFluent<A>> extends BaseFluent<A> implements DNSSpecFluent<A>{
  public DNSSpecFluentImpl() {
  }
  public DNSSpecFluentImpl(DNSSpec instance) {
    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withNodePlacement(instance.getNodePlacement());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withServers(instance.getServers());
      this.withUpstreamResolvers(instance.getUpstreamResolvers());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String logLevel;
  private String managementState;
  private DNSNodePlacementBuilder nodePlacement;
  private String operatorLogLevel;
  private ArrayList<ServerBuilder> servers = new ArrayList<ServerBuilder>();
  private UpstreamResolversBuilder upstreamResolvers;
  private Map<String,Object> additionalProperties;
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public String getManagementState() {
    return this.managementState;
  }
  public A withManagementState(String managementState) {
    this.managementState=managementState; return (A) this;
  }
  public Boolean hasManagementState() {
    return this.managementState != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNodePlacement instead.
   * @return The buildable object.
   */
  @Deprecated
  public DNSNodePlacement getNodePlacement() {
    return this.nodePlacement!=null ?this.nodePlacement.build():null;
  }
  public DNSNodePlacement buildNodePlacement() {
    return this.nodePlacement!=null ?this.nodePlacement.build():null;
  }
  public A withNodePlacement(DNSNodePlacement nodePlacement) {
    _visitables.get("nodePlacement").remove(this.nodePlacement);
    if (nodePlacement!=null){ this.nodePlacement= new DNSNodePlacementBuilder(nodePlacement); _visitables.get("nodePlacement").add(this.nodePlacement);} else { this.nodePlacement = null; _visitables.get("nodePlacement").remove(this.nodePlacement); } return (A) this;
  }
  public Boolean hasNodePlacement() {
    return this.nodePlacement != null;
  }
  public DNSSpecFluentImpl.NodePlacementNested<A> withNewNodePlacement() {
    return new DNSSpecFluentImpl.NodePlacementNestedImpl();
  }
  public DNSSpecFluentImpl.NodePlacementNested<A> withNewNodePlacementLike(DNSNodePlacement item) {
    return new DNSSpecFluentImpl.NodePlacementNestedImpl(item);
  }
  public DNSSpecFluentImpl.NodePlacementNested<A> editNodePlacement() {
    return withNewNodePlacementLike(getNodePlacement());
  }
  public DNSSpecFluentImpl.NodePlacementNested<A> editOrNewNodePlacement() {
    return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): new DNSNodePlacementBuilder().build());
  }
  public DNSSpecFluentImpl.NodePlacementNested<A> editOrNewNodePlacementLike(DNSNodePlacement item) {
    return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): item);
  }
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel=operatorLogLevel; return (A) this;
  }
  public Boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  public A addToServers(int index,Server item) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    ServerBuilder builder = new ServerBuilder(item);
    if (index < 0 || index >= servers.size()) { _visitables.get("servers").add(builder); servers.add(builder); } else { _visitables.get("servers").add(index, builder); servers.add(index, builder);}
    return (A)this;
  }
  public A setToServers(int index,Server item) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    ServerBuilder builder = new ServerBuilder(item);
    if (index < 0 || index >= servers.size()) { _visitables.get("servers").add(builder); servers.add(builder); } else { _visitables.get("servers").set(index, builder); servers.set(index, builder);}
    return (A)this;
  }
  public A addToServers(io.fabric8.openshift.api.model.operator.v1.Server... items) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  public A addAllToServers(Collection<Server> items) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  public A removeFromServers(io.fabric8.openshift.api.model.operator.v1.Server... items) {
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
  }
  public A removeAllFromServers(Collection<Server> items) {
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServers(Predicate<ServerBuilder> predicate) {
    if (servers == null) return (A) this;
    final Iterator<ServerBuilder> each = servers.iterator();
    final List visitables = _visitables.get("servers");
    while (each.hasNext()) {
      ServerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Server> getServers() {
    return servers != null ? build(servers) : null;
  }
  public List<Server> buildServers() {
    return servers != null ? build(servers) : null;
  }
  public Server buildServer(int index) {
    return this.servers.get(index).build();
  }
  public Server buildFirstServer() {
    return this.servers.get(0).build();
  }
  public Server buildLastServer() {
    return this.servers.get(servers.size() - 1).build();
  }
  public Server buildMatchingServer(Predicate<ServerBuilder> predicate) {
    for (ServerBuilder item: servers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingServer(Predicate<ServerBuilder> predicate) {
    for (ServerBuilder item: servers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServers(List<Server> servers) {
    if (this.servers != null) { _visitables.get("servers").clear();}
    if (servers != null) {this.servers = new ArrayList(); for (Server item : servers){this.addToServers(item);}} else { this.servers = null;} return (A) this;
  }
  public A withServers(io.fabric8.openshift.api.model.operator.v1.Server... servers) {
    if (this.servers != null) {this.servers.clear(); _visitables.remove("servers"); }
    if (servers != null) {for (Server item :servers){ this.addToServers(item);}} return (A) this;
  }
  public Boolean hasServers() {
    return servers != null && !servers.isEmpty();
  }
  public DNSSpecFluentImpl.ServersNested<A> addNewServer() {
    return new DNSSpecFluentImpl.ServersNestedImpl();
  }
  public DNSSpecFluentImpl.ServersNested<A> addNewServerLike(Server item) {
    return new DNSSpecFluentImpl.ServersNestedImpl(-1, item);
  }
  public DNSSpecFluentImpl.ServersNested<A> setNewServerLike(int index,Server item) {
    return new DNSSpecFluentImpl.ServersNestedImpl(index, item);
  }
  public DNSSpecFluentImpl.ServersNested<A> editServer(int index) {
    if (servers.size() <= index) throw new RuntimeException("Can't edit servers. Index exceeds size.");
    return setNewServerLike(index, buildServer(index));
  }
  public DNSSpecFluentImpl.ServersNested<A> editFirstServer() {
    if (servers.size() == 0) throw new RuntimeException("Can't edit first servers. The list is empty.");
    return setNewServerLike(0, buildServer(0));
  }
  public DNSSpecFluentImpl.ServersNested<A> editLastServer() {
    int index = servers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last servers. The list is empty.");
    return setNewServerLike(index, buildServer(index));
  }
  public DNSSpecFluentImpl.ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<servers.size();i++) { 
    if (predicate.test(servers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching servers. No match found.");
    return setNewServerLike(index, buildServer(index));
  }
  
  /**
   * This method has been deprecated, please use method buildUpstreamResolvers instead.
   * @return The buildable object.
   */
  @Deprecated
  public UpstreamResolvers getUpstreamResolvers() {
    return this.upstreamResolvers!=null ?this.upstreamResolvers.build():null;
  }
  public UpstreamResolvers buildUpstreamResolvers() {
    return this.upstreamResolvers!=null ?this.upstreamResolvers.build():null;
  }
  public A withUpstreamResolvers(UpstreamResolvers upstreamResolvers) {
    _visitables.get("upstreamResolvers").remove(this.upstreamResolvers);
    if (upstreamResolvers!=null){ this.upstreamResolvers= new UpstreamResolversBuilder(upstreamResolvers); _visitables.get("upstreamResolvers").add(this.upstreamResolvers);} else { this.upstreamResolvers = null; _visitables.get("upstreamResolvers").remove(this.upstreamResolvers); } return (A) this;
  }
  public Boolean hasUpstreamResolvers() {
    return this.upstreamResolvers != null;
  }
  public DNSSpecFluentImpl.UpstreamResolversNested<A> withNewUpstreamResolvers() {
    return new DNSSpecFluentImpl.UpstreamResolversNestedImpl();
  }
  public DNSSpecFluentImpl.UpstreamResolversNested<A> withNewUpstreamResolversLike(UpstreamResolvers item) {
    return new DNSSpecFluentImpl.UpstreamResolversNestedImpl(item);
  }
  public DNSSpecFluentImpl.UpstreamResolversNested<A> editUpstreamResolvers() {
    return withNewUpstreamResolversLike(getUpstreamResolvers());
  }
  public DNSSpecFluentImpl.UpstreamResolversNested<A> editOrNewUpstreamResolvers() {
    return withNewUpstreamResolversLike(getUpstreamResolvers() != null ? getUpstreamResolvers(): new UpstreamResolversBuilder().build());
  }
  public DNSSpecFluentImpl.UpstreamResolversNested<A> editOrNewUpstreamResolversLike(UpstreamResolvers item) {
    return withNewUpstreamResolversLike(getUpstreamResolvers() != null ? getUpstreamResolvers(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSSpecFluentImpl that = (DNSSpecFluentImpl) o;
    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;

    if (!java.util.Objects.equals(managementState, that.managementState)) return false;

    if (!java.util.Objects.equals(nodePlacement, that.nodePlacement)) return false;

    if (!java.util.Objects.equals(operatorLogLevel, that.operatorLogLevel)) return false;

    if (!java.util.Objects.equals(servers, that.servers)) return false;

    if (!java.util.Objects.equals(upstreamResolvers, that.upstreamResolvers)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(logLevel,  managementState,  nodePlacement,  operatorLogLevel,  servers,  upstreamResolvers,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (nodePlacement != null) { sb.append("nodePlacement:"); sb.append(nodePlacement + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (servers != null && !servers.isEmpty()) { sb.append("servers:"); sb.append(servers + ","); }
    if (upstreamResolvers != null) { sb.append("upstreamResolvers:"); sb.append(upstreamResolvers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class NodePlacementNestedImpl<N> extends DNSNodePlacementFluentImpl<DNSSpecFluentImpl.NodePlacementNested<N>> implements DNSSpecFluentImpl.NodePlacementNested<N>,Nested<N>{
    NodePlacementNestedImpl(DNSNodePlacement item) {
      this.builder = new DNSNodePlacementBuilder(this, item);
    }
    NodePlacementNestedImpl() {
      this.builder = new DNSNodePlacementBuilder(this);
    }
    DNSNodePlacementBuilder builder;
    public N and() {
      return (N) DNSSpecFluentImpl.this.withNodePlacement(builder.build());
    }
    public N endNodePlacement() {
      return and();
    }
    
  }
  class ServersNestedImpl<N> extends ServerFluentImpl<DNSSpecFluentImpl.ServersNested<N>> implements DNSSpecFluentImpl.ServersNested<N>,Nested<N>{
    ServersNestedImpl(int index,Server item) {
      this.index = index;
      this.builder = new ServerBuilder(this, item);
    }
    ServersNestedImpl() {
      this.index = -1;
      this.builder = new ServerBuilder(this);
    }
    ServerBuilder builder;
    int index;
    public N and() {
      return (N) DNSSpecFluentImpl.this.setToServers(index,builder.build());
    }
    public N endServer() {
      return and();
    }
    
  }
  class UpstreamResolversNestedImpl<N> extends UpstreamResolversFluentImpl<DNSSpecFluentImpl.UpstreamResolversNested<N>> implements DNSSpecFluentImpl.UpstreamResolversNested<N>,Nested<N>{
    UpstreamResolversNestedImpl(UpstreamResolvers item) {
      this.builder = new UpstreamResolversBuilder(this, item);
    }
    UpstreamResolversNestedImpl() {
      this.builder = new UpstreamResolversBuilder(this);
    }
    UpstreamResolversBuilder builder;
    public N and() {
      return (N) DNSSpecFluentImpl.this.withUpstreamResolvers(builder.build());
    }
    public N endUpstreamResolvers() {
      return and();
    }
    
  }
  
}