package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DefaultNetworkDefinitionFluentImpl<A extends DefaultNetworkDefinitionFluent<A>> extends BaseFluent<A> implements DefaultNetworkDefinitionFluent<A>{
  public DefaultNetworkDefinitionFluentImpl() {
  }
  public DefaultNetworkDefinitionFluentImpl(DefaultNetworkDefinition instance) {
    if (instance != null) {
      this.withKuryrConfig(instance.getKuryrConfig());
      this.withOpenshiftSDNConfig(instance.getOpenshiftSDNConfig());
      this.withOvnKubernetesConfig(instance.getOvnKubernetesConfig());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private KuryrConfigBuilder kuryrConfig;
  private OpenShiftSDNConfigBuilder openshiftSDNConfig;
  private OVNKubernetesConfigBuilder ovnKubernetesConfig;
  private String type;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildKuryrConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public KuryrConfig getKuryrConfig() {
    return this.kuryrConfig!=null ?this.kuryrConfig.build():null;
  }
  public KuryrConfig buildKuryrConfig() {
    return this.kuryrConfig!=null ?this.kuryrConfig.build():null;
  }
  public A withKuryrConfig(KuryrConfig kuryrConfig) {
    _visitables.get("kuryrConfig").remove(this.kuryrConfig);
    if (kuryrConfig!=null){ this.kuryrConfig= new KuryrConfigBuilder(kuryrConfig); _visitables.get("kuryrConfig").add(this.kuryrConfig);} else { this.kuryrConfig = null; _visitables.get("kuryrConfig").remove(this.kuryrConfig); } return (A) this;
  }
  public Boolean hasKuryrConfig() {
    return this.kuryrConfig != null;
  }
  public DefaultNetworkDefinitionFluentImpl.KuryrConfigNested<A> withNewKuryrConfig() {
    return new DefaultNetworkDefinitionFluentImpl.KuryrConfigNestedImpl();
  }
  public DefaultNetworkDefinitionFluentImpl.KuryrConfigNested<A> withNewKuryrConfigLike(KuryrConfig item) {
    return new DefaultNetworkDefinitionFluentImpl.KuryrConfigNestedImpl(item);
  }
  public DefaultNetworkDefinitionFluentImpl.KuryrConfigNested<A> editKuryrConfig() {
    return withNewKuryrConfigLike(getKuryrConfig());
  }
  public DefaultNetworkDefinitionFluentImpl.KuryrConfigNested<A> editOrNewKuryrConfig() {
    return withNewKuryrConfigLike(getKuryrConfig() != null ? getKuryrConfig(): new KuryrConfigBuilder().build());
  }
  public DefaultNetworkDefinitionFluentImpl.KuryrConfigNested<A> editOrNewKuryrConfigLike(KuryrConfig item) {
    return withNewKuryrConfigLike(getKuryrConfig() != null ? getKuryrConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOpenshiftSDNConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public OpenShiftSDNConfig getOpenshiftSDNConfig() {
    return this.openshiftSDNConfig!=null ?this.openshiftSDNConfig.build():null;
  }
  public OpenShiftSDNConfig buildOpenshiftSDNConfig() {
    return this.openshiftSDNConfig!=null ?this.openshiftSDNConfig.build():null;
  }
  public A withOpenshiftSDNConfig(OpenShiftSDNConfig openshiftSDNConfig) {
    _visitables.get("openshiftSDNConfig").remove(this.openshiftSDNConfig);
    if (openshiftSDNConfig!=null){ this.openshiftSDNConfig= new OpenShiftSDNConfigBuilder(openshiftSDNConfig); _visitables.get("openshiftSDNConfig").add(this.openshiftSDNConfig);} else { this.openshiftSDNConfig = null; _visitables.get("openshiftSDNConfig").remove(this.openshiftSDNConfig); } return (A) this;
  }
  public Boolean hasOpenshiftSDNConfig() {
    return this.openshiftSDNConfig != null;
  }
  public A withNewOpenshiftSDNConfig(Boolean enableUnidling,String mode,Integer mtu,Boolean useExternalOpenvswitch,Integer vxlanPort) {
    return (A)withOpenshiftSDNConfig(new OpenShiftSDNConfig(enableUnidling, mode, mtu, useExternalOpenvswitch, vxlanPort));
  }
  public DefaultNetworkDefinitionFluentImpl.OpenshiftSDNConfigNested<A> withNewOpenshiftSDNConfig() {
    return new DefaultNetworkDefinitionFluentImpl.OpenshiftSDNConfigNestedImpl();
  }
  public DefaultNetworkDefinitionFluentImpl.OpenshiftSDNConfigNested<A> withNewOpenshiftSDNConfigLike(OpenShiftSDNConfig item) {
    return new DefaultNetworkDefinitionFluentImpl.OpenshiftSDNConfigNestedImpl(item);
  }
  public DefaultNetworkDefinitionFluentImpl.OpenshiftSDNConfigNested<A> editOpenshiftSDNConfig() {
    return withNewOpenshiftSDNConfigLike(getOpenshiftSDNConfig());
  }
  public DefaultNetworkDefinitionFluentImpl.OpenshiftSDNConfigNested<A> editOrNewOpenshiftSDNConfig() {
    return withNewOpenshiftSDNConfigLike(getOpenshiftSDNConfig() != null ? getOpenshiftSDNConfig(): new OpenShiftSDNConfigBuilder().build());
  }
  public DefaultNetworkDefinitionFluentImpl.OpenshiftSDNConfigNested<A> editOrNewOpenshiftSDNConfigLike(OpenShiftSDNConfig item) {
    return withNewOpenshiftSDNConfigLike(getOpenshiftSDNConfig() != null ? getOpenshiftSDNConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOvnKubernetesConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public OVNKubernetesConfig getOvnKubernetesConfig() {
    return this.ovnKubernetesConfig!=null ?this.ovnKubernetesConfig.build():null;
  }
  public OVNKubernetesConfig buildOvnKubernetesConfig() {
    return this.ovnKubernetesConfig!=null ?this.ovnKubernetesConfig.build():null;
  }
  public A withOvnKubernetesConfig(OVNKubernetesConfig ovnKubernetesConfig) {
    _visitables.get("ovnKubernetesConfig").remove(this.ovnKubernetesConfig);
    if (ovnKubernetesConfig!=null){ this.ovnKubernetesConfig= new OVNKubernetesConfigBuilder(ovnKubernetesConfig); _visitables.get("ovnKubernetesConfig").add(this.ovnKubernetesConfig);} else { this.ovnKubernetesConfig = null; _visitables.get("ovnKubernetesConfig").remove(this.ovnKubernetesConfig); } return (A) this;
  }
  public Boolean hasOvnKubernetesConfig() {
    return this.ovnKubernetesConfig != null;
  }
  public DefaultNetworkDefinitionFluentImpl.OvnKubernetesConfigNested<A> withNewOvnKubernetesConfig() {
    return new DefaultNetworkDefinitionFluentImpl.OvnKubernetesConfigNestedImpl();
  }
  public DefaultNetworkDefinitionFluentImpl.OvnKubernetesConfigNested<A> withNewOvnKubernetesConfigLike(OVNKubernetesConfig item) {
    return new DefaultNetworkDefinitionFluentImpl.OvnKubernetesConfigNestedImpl(item);
  }
  public DefaultNetworkDefinitionFluentImpl.OvnKubernetesConfigNested<A> editOvnKubernetesConfig() {
    return withNewOvnKubernetesConfigLike(getOvnKubernetesConfig());
  }
  public DefaultNetworkDefinitionFluentImpl.OvnKubernetesConfigNested<A> editOrNewOvnKubernetesConfig() {
    return withNewOvnKubernetesConfigLike(getOvnKubernetesConfig() != null ? getOvnKubernetesConfig(): new OVNKubernetesConfigBuilder().build());
  }
  public DefaultNetworkDefinitionFluentImpl.OvnKubernetesConfigNested<A> editOrNewOvnKubernetesConfigLike(OVNKubernetesConfig item) {
    return withNewOvnKubernetesConfigLike(getOvnKubernetesConfig() != null ? getOvnKubernetesConfig(): item);
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DefaultNetworkDefinitionFluentImpl that = (DefaultNetworkDefinitionFluentImpl) o;
    if (!java.util.Objects.equals(kuryrConfig, that.kuryrConfig)) return false;

    if (!java.util.Objects.equals(openshiftSDNConfig, that.openshiftSDNConfig)) return false;

    if (!java.util.Objects.equals(ovnKubernetesConfig, that.ovnKubernetesConfig)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(kuryrConfig,  openshiftSDNConfig,  ovnKubernetesConfig,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kuryrConfig != null) { sb.append("kuryrConfig:"); sb.append(kuryrConfig + ","); }
    if (openshiftSDNConfig != null) { sb.append("openshiftSDNConfig:"); sb.append(openshiftSDNConfig + ","); }
    if (ovnKubernetesConfig != null) { sb.append("ovnKubernetesConfig:"); sb.append(ovnKubernetesConfig + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class KuryrConfigNestedImpl<N> extends KuryrConfigFluentImpl<DefaultNetworkDefinitionFluentImpl.KuryrConfigNested<N>> implements DefaultNetworkDefinitionFluentImpl.KuryrConfigNested<N>,Nested<N>{
    KuryrConfigNestedImpl(KuryrConfig item) {
      this.builder = new KuryrConfigBuilder(this, item);
    }
    KuryrConfigNestedImpl() {
      this.builder = new KuryrConfigBuilder(this);
    }
    KuryrConfigBuilder builder;
    public N and() {
      return (N) DefaultNetworkDefinitionFluentImpl.this.withKuryrConfig(builder.build());
    }
    public N endKuryrConfig() {
      return and();
    }
    
  }
  class OpenshiftSDNConfigNestedImpl<N> extends OpenShiftSDNConfigFluentImpl<DefaultNetworkDefinitionFluentImpl.OpenshiftSDNConfigNested<N>> implements DefaultNetworkDefinitionFluentImpl.OpenshiftSDNConfigNested<N>,Nested<N>{
    OpenshiftSDNConfigNestedImpl(OpenShiftSDNConfig item) {
      this.builder = new OpenShiftSDNConfigBuilder(this, item);
    }
    OpenshiftSDNConfigNestedImpl() {
      this.builder = new OpenShiftSDNConfigBuilder(this);
    }
    OpenShiftSDNConfigBuilder builder;
    public N and() {
      return (N) DefaultNetworkDefinitionFluentImpl.this.withOpenshiftSDNConfig(builder.build());
    }
    public N endOpenshiftSDNConfig() {
      return and();
    }
    
  }
  class OvnKubernetesConfigNestedImpl<N> extends OVNKubernetesConfigFluentImpl<DefaultNetworkDefinitionFluentImpl.OvnKubernetesConfigNested<N>> implements DefaultNetworkDefinitionFluentImpl.OvnKubernetesConfigNested<N>,Nested<N>{
    OvnKubernetesConfigNestedImpl(OVNKubernetesConfig item) {
      this.builder = new OVNKubernetesConfigBuilder(this, item);
    }
    OvnKubernetesConfigNestedImpl() {
      this.builder = new OVNKubernetesConfigBuilder(this);
    }
    OVNKubernetesConfigBuilder builder;
    public N and() {
      return (N) DefaultNetworkDefinitionFluentImpl.this.withOvnKubernetesConfig(builder.build());
    }
    public N endOvnKubernetesConfig() {
      return and();
    }
    
  }
  
}