package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeveloperConsoleCatalogCategoryMetaBuilder extends DeveloperConsoleCatalogCategoryMetaFluentImpl<DeveloperConsoleCatalogCategoryMetaBuilder> implements VisitableBuilder<DeveloperConsoleCatalogCategoryMeta,DeveloperConsoleCatalogCategoryMetaBuilder>{
  public DeveloperConsoleCatalogCategoryMetaBuilder() {
    this(false);
  }
  public DeveloperConsoleCatalogCategoryMetaBuilder(Boolean validationEnabled) {
    this(new DeveloperConsoleCatalogCategoryMeta(), validationEnabled);
  }
  public DeveloperConsoleCatalogCategoryMetaBuilder(DeveloperConsoleCatalogCategoryMetaFluent<?> fluent) {
    this(fluent, false);
  }
  public DeveloperConsoleCatalogCategoryMetaBuilder(DeveloperConsoleCatalogCategoryMetaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeveloperConsoleCatalogCategoryMeta(), validationEnabled);
  }
  public DeveloperConsoleCatalogCategoryMetaBuilder(DeveloperConsoleCatalogCategoryMetaFluent<?> fluent,DeveloperConsoleCatalogCategoryMeta instance) {
    this(fluent, instance, false);
  }
  public DeveloperConsoleCatalogCategoryMetaBuilder(DeveloperConsoleCatalogCategoryMetaFluent<?> fluent,DeveloperConsoleCatalogCategoryMeta instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withId(instance.getId());
      fluent.withLabel(instance.getLabel());
      fluent.withTags(instance.getTags());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeveloperConsoleCatalogCategoryMetaBuilder(DeveloperConsoleCatalogCategoryMeta instance) {
    this(instance,false);
  }
  public DeveloperConsoleCatalogCategoryMetaBuilder(DeveloperConsoleCatalogCategoryMeta instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withId(instance.getId());
      this.withLabel(instance.getLabel());
      this.withTags(instance.getTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeveloperConsoleCatalogCategoryMetaFluent<?> fluent;
  Boolean validationEnabled;
  public DeveloperConsoleCatalogCategoryMeta build() {
    DeveloperConsoleCatalogCategoryMeta buildable = new DeveloperConsoleCatalogCategoryMeta(fluent.getId(),fluent.getLabel(),fluent.getTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}