package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeveloperConsoleCatalogCustomizationBuilder extends DeveloperConsoleCatalogCustomizationFluentImpl<DeveloperConsoleCatalogCustomizationBuilder> implements VisitableBuilder<DeveloperConsoleCatalogCustomization,DeveloperConsoleCatalogCustomizationBuilder>{
  public DeveloperConsoleCatalogCustomizationBuilder() {
    this(false);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(Boolean validationEnabled) {
    this(new DeveloperConsoleCatalogCustomization(), validationEnabled);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomizationFluent<?> fluent) {
    this(fluent, false);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomizationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeveloperConsoleCatalogCustomization(), validationEnabled);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomizationFluent<?> fluent,DeveloperConsoleCatalogCustomization instance) {
    this(fluent, instance, false);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomizationFluent<?> fluent,DeveloperConsoleCatalogCustomization instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCategories(instance.getCategories());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomization instance) {
    this(instance,false);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomization instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCategories(instance.getCategories());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeveloperConsoleCatalogCustomizationFluent<?> fluent;
  Boolean validationEnabled;
  public DeveloperConsoleCatalogCustomization build() {
    DeveloperConsoleCatalogCustomization buildable = new DeveloperConsoleCatalogCustomization(fluent.getCategories());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}