package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DeveloperConsoleCatalogCustomizationFluentImpl<A extends DeveloperConsoleCatalogCustomizationFluent<A>> extends BaseFluent<A> implements DeveloperConsoleCatalogCustomizationFluent<A>{
  public DeveloperConsoleCatalogCustomizationFluentImpl() {
  }
  public DeveloperConsoleCatalogCustomizationFluentImpl(DeveloperConsoleCatalogCustomization instance) {
    if (instance != null) {
      this.withCategories(instance.getCategories());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<DeveloperConsoleCatalogCategoryBuilder> categories = new ArrayList<DeveloperConsoleCatalogCategoryBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToCategories(int index,DeveloperConsoleCatalogCategory item) {
    if (this.categories == null) {this.categories = new ArrayList<DeveloperConsoleCatalogCategoryBuilder>();}
    DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);
    if (index < 0 || index >= categories.size()) { _visitables.get("categories").add(builder); categories.add(builder); } else { _visitables.get("categories").add(index, builder); categories.add(index, builder);}
    return (A)this;
  }
  public A setToCategories(int index,DeveloperConsoleCatalogCategory item) {
    if (this.categories == null) {this.categories = new ArrayList<DeveloperConsoleCatalogCategoryBuilder>();}
    DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);
    if (index < 0 || index >= categories.size()) { _visitables.get("categories").add(builder); categories.add(builder); } else { _visitables.get("categories").set(index, builder); categories.set(index, builder);}
    return (A)this;
  }
  public A addToCategories(io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategory... items) {
    if (this.categories == null) {this.categories = new ArrayList<DeveloperConsoleCatalogCategoryBuilder>();}
    for (DeveloperConsoleCatalogCategory item : items) {DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);_visitables.get("categories").add(builder);this.categories.add(builder);} return (A)this;
  }
  public A addAllToCategories(Collection<DeveloperConsoleCatalogCategory> items) {
    if (this.categories == null) {this.categories = new ArrayList<DeveloperConsoleCatalogCategoryBuilder>();}
    for (DeveloperConsoleCatalogCategory item : items) {DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);_visitables.get("categories").add(builder);this.categories.add(builder);} return (A)this;
  }
  public A removeFromCategories(io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategory... items) {
    for (DeveloperConsoleCatalogCategory item : items) {DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);_visitables.get("categories").remove(builder);if (this.categories != null) {this.categories.remove(builder);}} return (A)this;
  }
  public A removeAllFromCategories(Collection<DeveloperConsoleCatalogCategory> items) {
    for (DeveloperConsoleCatalogCategory item : items) {DeveloperConsoleCatalogCategoryBuilder builder = new DeveloperConsoleCatalogCategoryBuilder(item);_visitables.get("categories").remove(builder);if (this.categories != null) {this.categories.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCategories(Predicate<DeveloperConsoleCatalogCategoryBuilder> predicate) {
    if (categories == null) return (A) this;
    final Iterator<DeveloperConsoleCatalogCategoryBuilder> each = categories.iterator();
    final List visitables = _visitables.get("categories");
    while (each.hasNext()) {
      DeveloperConsoleCatalogCategoryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildCategories instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DeveloperConsoleCatalogCategory> getCategories() {
    return categories != null ? build(categories) : null;
  }
  public List<DeveloperConsoleCatalogCategory> buildCategories() {
    return categories != null ? build(categories) : null;
  }
  public DeveloperConsoleCatalogCategory buildCategory(int index) {
    return this.categories.get(index).build();
  }
  public DeveloperConsoleCatalogCategory buildFirstCategory() {
    return this.categories.get(0).build();
  }
  public DeveloperConsoleCatalogCategory buildLastCategory() {
    return this.categories.get(categories.size() - 1).build();
  }
  public DeveloperConsoleCatalogCategory buildMatchingCategory(Predicate<DeveloperConsoleCatalogCategoryBuilder> predicate) {
    for (DeveloperConsoleCatalogCategoryBuilder item: categories) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCategory(Predicate<DeveloperConsoleCatalogCategoryBuilder> predicate) {
    for (DeveloperConsoleCatalogCategoryBuilder item: categories) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCategories(List<DeveloperConsoleCatalogCategory> categories) {
    if (this.categories != null) { _visitables.get("categories").clear();}
    if (categories != null) {this.categories = new ArrayList(); for (DeveloperConsoleCatalogCategory item : categories){this.addToCategories(item);}} else { this.categories = null;} return (A) this;
  }
  public A withCategories(io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategory... categories) {
    if (this.categories != null) {this.categories.clear(); _visitables.remove("categories"); }
    if (categories != null) {for (DeveloperConsoleCatalogCategory item :categories){ this.addToCategories(item);}} return (A) this;
  }
  public Boolean hasCategories() {
    return categories != null && !categories.isEmpty();
  }
  public DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNested<A> addNewCategory() {
    return new DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNestedImpl();
  }
  public DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNested<A> addNewCategoryLike(DeveloperConsoleCatalogCategory item) {
    return new DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNestedImpl(-1, item);
  }
  public DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNested<A> setNewCategoryLike(int index,DeveloperConsoleCatalogCategory item) {
    return new DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNestedImpl(index, item);
  }
  public DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNested<A> editCategory(int index) {
    if (categories.size() <= index) throw new RuntimeException("Can't edit categories. Index exceeds size.");
    return setNewCategoryLike(index, buildCategory(index));
  }
  public DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNested<A> editFirstCategory() {
    if (categories.size() == 0) throw new RuntimeException("Can't edit first categories. The list is empty.");
    return setNewCategoryLike(0, buildCategory(0));
  }
  public DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNested<A> editLastCategory() {
    int index = categories.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last categories. The list is empty.");
    return setNewCategoryLike(index, buildCategory(index));
  }
  public DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNested<A> editMatchingCategory(Predicate<DeveloperConsoleCatalogCategoryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<categories.size();i++) { 
    if (predicate.test(categories.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching categories. No match found.");
    return setNewCategoryLike(index, buildCategory(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeveloperConsoleCatalogCustomizationFluentImpl that = (DeveloperConsoleCatalogCustomizationFluentImpl) o;
    if (!java.util.Objects.equals(categories, that.categories)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(categories,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (categories != null && !categories.isEmpty()) { sb.append("categories:"); sb.append(categories + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CategoriesNestedImpl<N> extends DeveloperConsoleCatalogCategoryFluentImpl<DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNested<N>> implements DeveloperConsoleCatalogCustomizationFluentImpl.CategoriesNested<N>,Nested<N>{
    CategoriesNestedImpl(int index,DeveloperConsoleCatalogCategory item) {
      this.index = index;
      this.builder = new DeveloperConsoleCatalogCategoryBuilder(this, item);
    }
    CategoriesNestedImpl() {
      this.index = -1;
      this.builder = new DeveloperConsoleCatalogCategoryBuilder(this);
    }
    DeveloperConsoleCatalogCategoryBuilder builder;
    int index;
    public N and() {
      return (N) DeveloperConsoleCatalogCustomizationFluentImpl.this.setToCategories(index,builder.build());
    }
    public N endCategory() {
      return and();
    }
    
  }
  
}