package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointPublishingStrategyBuilder extends EndpointPublishingStrategyFluentImpl<EndpointPublishingStrategyBuilder> implements VisitableBuilder<EndpointPublishingStrategy,EndpointPublishingStrategyBuilder>{
  public EndpointPublishingStrategyBuilder() {
    this(false);
  }
  public EndpointPublishingStrategyBuilder(Boolean validationEnabled) {
    this(new EndpointPublishingStrategy(), validationEnabled);
  }
  public EndpointPublishingStrategyBuilder(EndpointPublishingStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointPublishingStrategyBuilder(EndpointPublishingStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EndpointPublishingStrategy(), validationEnabled);
  }
  public EndpointPublishingStrategyBuilder(EndpointPublishingStrategyFluent<?> fluent,EndpointPublishingStrategy instance) {
    this(fluent, instance, false);
  }
  public EndpointPublishingStrategyBuilder(EndpointPublishingStrategyFluent<?> fluent,EndpointPublishingStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withHostNetwork(instance.getHostNetwork());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withNodePort(instance.getNodePort());
      fluent.withPrivate(instance.getPrivate());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EndpointPublishingStrategyBuilder(EndpointPublishingStrategy instance) {
    this(instance,false);
  }
  public EndpointPublishingStrategyBuilder(EndpointPublishingStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withHostNetwork(instance.getHostNetwork());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withNodePort(instance.getNodePort());
      this.withPrivate(instance.getPrivate());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EndpointPublishingStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public EndpointPublishingStrategy build() {
    EndpointPublishingStrategy buildable = new EndpointPublishingStrategy(fluent.getHostNetwork(),fluent.getLoadBalancer(),fluent.getNodePort(),fluent.getPrivate(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}