package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EndpointPublishingStrategyFluentImpl<A extends EndpointPublishingStrategyFluent<A>> extends BaseFluent<A> implements EndpointPublishingStrategyFluent<A>{
  public EndpointPublishingStrategyFluentImpl() {
  }
  public EndpointPublishingStrategyFluentImpl(EndpointPublishingStrategy instance) {
    if (instance != null) {
      this.withHostNetwork(instance.getHostNetwork());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withNodePort(instance.getNodePort());
      this.withPrivate(instance.getPrivate());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private HostNetworkStrategyBuilder hostNetwork;
  private LoadBalancerStrategyBuilder loadBalancer;
  private NodePortStrategyBuilder nodePort;
  private PrivateStrategyBuilder _private;
  private String type;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildHostNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public HostNetworkStrategy getHostNetwork() {
    return this.hostNetwork!=null ?this.hostNetwork.build():null;
  }
  public HostNetworkStrategy buildHostNetwork() {
    return this.hostNetwork!=null ?this.hostNetwork.build():null;
  }
  public A withHostNetwork(HostNetworkStrategy hostNetwork) {
    _visitables.get("hostNetwork").remove(this.hostNetwork);
    if (hostNetwork!=null){ this.hostNetwork= new HostNetworkStrategyBuilder(hostNetwork); _visitables.get("hostNetwork").add(this.hostNetwork);} else { this.hostNetwork = null; _visitables.get("hostNetwork").remove(this.hostNetwork); } return (A) this;
  }
  public Boolean hasHostNetwork() {
    return this.hostNetwork != null;
  }
  public A withNewHostNetwork(String protocol) {
    return (A)withHostNetwork(new HostNetworkStrategy(protocol));
  }
  public EndpointPublishingStrategyFluentImpl.HostNetworkNested<A> withNewHostNetwork() {
    return new EndpointPublishingStrategyFluentImpl.HostNetworkNestedImpl();
  }
  public EndpointPublishingStrategyFluentImpl.HostNetworkNested<A> withNewHostNetworkLike(HostNetworkStrategy item) {
    return new EndpointPublishingStrategyFluentImpl.HostNetworkNestedImpl(item);
  }
  public EndpointPublishingStrategyFluentImpl.HostNetworkNested<A> editHostNetwork() {
    return withNewHostNetworkLike(getHostNetwork());
  }
  public EndpointPublishingStrategyFluentImpl.HostNetworkNested<A> editOrNewHostNetwork() {
    return withNewHostNetworkLike(getHostNetwork() != null ? getHostNetwork(): new HostNetworkStrategyBuilder().build());
  }
  public EndpointPublishingStrategyFluentImpl.HostNetworkNested<A> editOrNewHostNetworkLike(HostNetworkStrategy item) {
    return withNewHostNetworkLike(getHostNetwork() != null ? getHostNetwork(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLoadBalancer instead.
   * @return The buildable object.
   */
  @Deprecated
  public LoadBalancerStrategy getLoadBalancer() {
    return this.loadBalancer!=null ?this.loadBalancer.build():null;
  }
  public LoadBalancerStrategy buildLoadBalancer() {
    return this.loadBalancer!=null ?this.loadBalancer.build():null;
  }
  public A withLoadBalancer(LoadBalancerStrategy loadBalancer) {
    _visitables.get("loadBalancer").remove(this.loadBalancer);
    if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerStrategyBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} else { this.loadBalancer = null; _visitables.get("loadBalancer").remove(this.loadBalancer); } return (A) this;
  }
  public Boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  public EndpointPublishingStrategyFluentImpl.LoadBalancerNested<A> withNewLoadBalancer() {
    return new EndpointPublishingStrategyFluentImpl.LoadBalancerNestedImpl();
  }
  public EndpointPublishingStrategyFluentImpl.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerStrategy item) {
    return new EndpointPublishingStrategyFluentImpl.LoadBalancerNestedImpl(item);
  }
  public EndpointPublishingStrategyFluentImpl.LoadBalancerNested<A> editLoadBalancer() {
    return withNewLoadBalancerLike(getLoadBalancer());
  }
  public EndpointPublishingStrategyFluentImpl.LoadBalancerNested<A> editOrNewLoadBalancer() {
    return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): new LoadBalancerStrategyBuilder().build());
  }
  public EndpointPublishingStrategyFluentImpl.LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerStrategy item) {
    return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodePort instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodePortStrategy getNodePort() {
    return this.nodePort!=null ?this.nodePort.build():null;
  }
  public NodePortStrategy buildNodePort() {
    return this.nodePort!=null ?this.nodePort.build():null;
  }
  public A withNodePort(NodePortStrategy nodePort) {
    _visitables.get("nodePort").remove(this.nodePort);
    if (nodePort!=null){ this.nodePort= new NodePortStrategyBuilder(nodePort); _visitables.get("nodePort").add(this.nodePort);} else { this.nodePort = null; _visitables.get("nodePort").remove(this.nodePort); } return (A) this;
  }
  public Boolean hasNodePort() {
    return this.nodePort != null;
  }
  public A withNewNodePort(String protocol) {
    return (A)withNodePort(new NodePortStrategy(protocol));
  }
  public EndpointPublishingStrategyFluentImpl.NodePortNested<A> withNewNodePort() {
    return new EndpointPublishingStrategyFluentImpl.NodePortNestedImpl();
  }
  public EndpointPublishingStrategyFluentImpl.NodePortNested<A> withNewNodePortLike(NodePortStrategy item) {
    return new EndpointPublishingStrategyFluentImpl.NodePortNestedImpl(item);
  }
  public EndpointPublishingStrategyFluentImpl.NodePortNested<A> editNodePort() {
    return withNewNodePortLike(getNodePort());
  }
  public EndpointPublishingStrategyFluentImpl.NodePortNested<A> editOrNewNodePort() {
    return withNewNodePortLike(getNodePort() != null ? getNodePort(): new NodePortStrategyBuilder().build());
  }
  public EndpointPublishingStrategyFluentImpl.NodePortNested<A> editOrNewNodePortLike(NodePortStrategy item) {
    return withNewNodePortLike(getNodePort() != null ? getNodePort(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPrivate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PrivateStrategy getPrivate() {
    return this._private!=null ?this._private.build():null;
  }
  public PrivateStrategy buildPrivate() {
    return this._private!=null ?this._private.build():null;
  }
  public A withPrivate(PrivateStrategy _private) {
    _visitables.get("_private").remove(this._private);
    if (_private!=null){ this._private= new PrivateStrategyBuilder(_private); _visitables.get("_private").add(this._private);} else { this._private = null; _visitables.get("_private").remove(this._private); } return (A) this;
  }
  public Boolean hasPrivate() {
    return this._private != null;
  }
  public EndpointPublishingStrategyFluentImpl.PrivateNested<A> withNewPrivate() {
    return new EndpointPublishingStrategyFluentImpl.PrivateNestedImpl();
  }
  public EndpointPublishingStrategyFluentImpl.PrivateNested<A> withNewPrivateLike(PrivateStrategy item) {
    return new EndpointPublishingStrategyFluentImpl.PrivateNestedImpl(item);
  }
  public EndpointPublishingStrategyFluentImpl.PrivateNested<A> editPrivate() {
    return withNewPrivateLike(getPrivate());
  }
  public EndpointPublishingStrategyFluentImpl.PrivateNested<A> editOrNewPrivate() {
    return withNewPrivateLike(getPrivate() != null ? getPrivate(): new PrivateStrategyBuilder().build());
  }
  public EndpointPublishingStrategyFluentImpl.PrivateNested<A> editOrNewPrivateLike(PrivateStrategy item) {
    return withNewPrivateLike(getPrivate() != null ? getPrivate(): item);
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointPublishingStrategyFluentImpl that = (EndpointPublishingStrategyFluentImpl) o;
    if (!java.util.Objects.equals(hostNetwork, that.hostNetwork)) return false;

    if (!java.util.Objects.equals(loadBalancer, that.loadBalancer)) return false;

    if (!java.util.Objects.equals(nodePort, that.nodePort)) return false;

    if (!java.util.Objects.equals(_private, that._private)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(hostNetwork,  loadBalancer,  nodePort,  _private,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostNetwork != null) { sb.append("hostNetwork:"); sb.append(hostNetwork + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (nodePort != null) { sb.append("nodePort:"); sb.append(nodePort + ","); }
    if (_private != null) { sb.append("_private:"); sb.append(_private + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class HostNetworkNestedImpl<N> extends HostNetworkStrategyFluentImpl<EndpointPublishingStrategyFluentImpl.HostNetworkNested<N>> implements EndpointPublishingStrategyFluentImpl.HostNetworkNested<N>,Nested<N>{
    HostNetworkNestedImpl(HostNetworkStrategy item) {
      this.builder = new HostNetworkStrategyBuilder(this, item);
    }
    HostNetworkNestedImpl() {
      this.builder = new HostNetworkStrategyBuilder(this);
    }
    HostNetworkStrategyBuilder builder;
    public N and() {
      return (N) EndpointPublishingStrategyFluentImpl.this.withHostNetwork(builder.build());
    }
    public N endHostNetwork() {
      return and();
    }
    
  }
  class LoadBalancerNestedImpl<N> extends LoadBalancerStrategyFluentImpl<EndpointPublishingStrategyFluentImpl.LoadBalancerNested<N>> implements EndpointPublishingStrategyFluentImpl.LoadBalancerNested<N>,Nested<N>{
    LoadBalancerNestedImpl(LoadBalancerStrategy item) {
      this.builder = new LoadBalancerStrategyBuilder(this, item);
    }
    LoadBalancerNestedImpl() {
      this.builder = new LoadBalancerStrategyBuilder(this);
    }
    LoadBalancerStrategyBuilder builder;
    public N and() {
      return (N) EndpointPublishingStrategyFluentImpl.this.withLoadBalancer(builder.build());
    }
    public N endLoadBalancer() {
      return and();
    }
    
  }
  class NodePortNestedImpl<N> extends NodePortStrategyFluentImpl<EndpointPublishingStrategyFluentImpl.NodePortNested<N>> implements EndpointPublishingStrategyFluentImpl.NodePortNested<N>,Nested<N>{
    NodePortNestedImpl(NodePortStrategy item) {
      this.builder = new NodePortStrategyBuilder(this, item);
    }
    NodePortNestedImpl() {
      this.builder = new NodePortStrategyBuilder(this);
    }
    NodePortStrategyBuilder builder;
    public N and() {
      return (N) EndpointPublishingStrategyFluentImpl.this.withNodePort(builder.build());
    }
    public N endNodePort() {
      return and();
    }
    
  }
  class PrivateNestedImpl<N> extends PrivateStrategyFluentImpl<EndpointPublishingStrategyFluentImpl.PrivateNested<N>> implements EndpointPublishingStrategyFluentImpl.PrivateNested<N>,Nested<N>{
    PrivateNestedImpl(PrivateStrategy item) {
      this.builder = new PrivateStrategyBuilder(this, item);
    }
    PrivateNestedImpl() {
      this.builder = new PrivateStrategyBuilder(this);
    }
    PrivateStrategyBuilder builder;
    public N and() {
      return (N) EndpointPublishingStrategyFluentImpl.this.withPrivate(builder.build());
    }
    public N endPrivate() {
      return and();
    }
    
  }
  
}