package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface EtcdFluent<A extends EtcdFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public EtcdFluent.MetadataNested<A> withNewMetadata();
  public EtcdFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public EtcdFluent.MetadataNested<A> editMetadata();
  public EtcdFluent.MetadataNested<A> editOrNewMetadata();
  public EtcdFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public EtcdSpec getSpec();
  public EtcdSpec buildSpec();
  public A withSpec(EtcdSpec spec);
  public Boolean hasSpec();
  public EtcdFluent.SpecNested<A> withNewSpec();
  public EtcdFluent.SpecNested<A> withNewSpecLike(EtcdSpec item);
  public EtcdFluent.SpecNested<A> editSpec();
  public EtcdFluent.SpecNested<A> editOrNewSpec();
  public EtcdFluent.SpecNested<A> editOrNewSpecLike(EtcdSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public EtcdStatus getStatus();
  public EtcdStatus buildStatus();
  public A withStatus(EtcdStatus status);
  public Boolean hasStatus();
  public EtcdFluent.StatusNested<A> withNewStatus();
  public EtcdFluent.StatusNested<A> withNewStatusLike(EtcdStatus item);
  public EtcdFluent.StatusNested<A> editStatus();
  public EtcdFluent.StatusNested<A> editOrNewStatus();
  public EtcdFluent.StatusNested<A> editOrNewStatusLike(EtcdStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<EtcdFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,EtcdSpecFluent<EtcdFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,EtcdStatusFluent<EtcdFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}