package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ForwardPluginBuilder extends ForwardPluginFluentImpl<ForwardPluginBuilder> implements VisitableBuilder<ForwardPlugin,ForwardPluginBuilder>{
  public ForwardPluginBuilder() {
    this(false);
  }
  public ForwardPluginBuilder(Boolean validationEnabled) {
    this(new ForwardPlugin(), validationEnabled);
  }
  public ForwardPluginBuilder(ForwardPluginFluent<?> fluent) {
    this(fluent, false);
  }
  public ForwardPluginBuilder(ForwardPluginFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ForwardPlugin(), validationEnabled);
  }
  public ForwardPluginBuilder(ForwardPluginFluent<?> fluent,ForwardPlugin instance) {
    this(fluent, instance, false);
  }
  public ForwardPluginBuilder(ForwardPluginFluent<?> fluent,ForwardPlugin instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPolicy(instance.getPolicy());
      fluent.withUpstreams(instance.getUpstreams());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ForwardPluginBuilder(ForwardPlugin instance) {
    this(instance,false);
  }
  public ForwardPluginBuilder(ForwardPlugin instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPolicy(instance.getPolicy());
      this.withUpstreams(instance.getUpstreams());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ForwardPluginFluent<?> fluent;
  Boolean validationEnabled;
  public ForwardPlugin build() {
    ForwardPlugin buildable = new ForwardPlugin(fluent.getPolicy(),fluent.getUpstreams());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}