package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPCompressionPolicyBuilder extends HTTPCompressionPolicyFluentImpl<HTTPCompressionPolicyBuilder> implements VisitableBuilder<HTTPCompressionPolicy,HTTPCompressionPolicyBuilder>{
  public HTTPCompressionPolicyBuilder() {
    this(false);
  }
  public HTTPCompressionPolicyBuilder(Boolean validationEnabled) {
    this(new HTTPCompressionPolicy(), validationEnabled);
  }
  public HTTPCompressionPolicyBuilder(HTTPCompressionPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPCompressionPolicyBuilder(HTTPCompressionPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPCompressionPolicy(), validationEnabled);
  }
  public HTTPCompressionPolicyBuilder(HTTPCompressionPolicyFluent<?> fluent,HTTPCompressionPolicy instance) {
    this(fluent, instance, false);
  }
  public HTTPCompressionPolicyBuilder(HTTPCompressionPolicyFluent<?> fluent,HTTPCompressionPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMimeTypes(instance.getMimeTypes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPCompressionPolicyBuilder(HTTPCompressionPolicy instance) {
    this(instance,false);
  }
  public HTTPCompressionPolicyBuilder(HTTPCompressionPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMimeTypes(instance.getMimeTypes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPCompressionPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPCompressionPolicy build() {
    HTTPCompressionPolicy buildable = new HTTPCompressionPolicy(fluent.getMimeTypes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}