package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostNetworkStrategyBuilder extends HostNetworkStrategyFluentImpl<HostNetworkStrategyBuilder> implements VisitableBuilder<HostNetworkStrategy,HostNetworkStrategyBuilder>{
  public HostNetworkStrategyBuilder() {
    this(false);
  }
  public HostNetworkStrategyBuilder(Boolean validationEnabled) {
    this(new HostNetworkStrategy(), validationEnabled);
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HostNetworkStrategy(), validationEnabled);
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent,HostNetworkStrategy instance) {
    this(fluent, instance, false);
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategyFluent<?> fluent,HostNetworkStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withProtocol(instance.getProtocol());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategy instance) {
    this(instance,false);
  }
  public HostNetworkStrategyBuilder(HostNetworkStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withProtocol(instance.getProtocol());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HostNetworkStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public HostNetworkStrategy build() {
    HostNetworkStrategy buildable = new HostNetworkStrategy(fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}