package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HybridOverlayConfigFluentImpl<A extends HybridOverlayConfigFluent<A>> extends BaseFluent<A> implements HybridOverlayConfigFluent<A>{
  public HybridOverlayConfigFluentImpl() {
  }
  public HybridOverlayConfigFluentImpl(HybridOverlayConfig instance) {
    if (instance != null) {
      this.withHybridClusterNetwork(instance.getHybridClusterNetwork());
      this.withHybridOverlayVXLANPort(instance.getHybridOverlayVXLANPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ClusterNetworkEntryBuilder> hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
  private Integer hybridOverlayVXLANPort;
  private Map<String,Object> additionalProperties;
  public A addToHybridClusterNetwork(int index,ClusterNetworkEntry item) {
    if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= hybridClusterNetwork.size()) { _visitables.get("hybridClusterNetwork").add(builder); hybridClusterNetwork.add(builder); } else { _visitables.get("hybridClusterNetwork").add(index, builder); hybridClusterNetwork.add(index, builder);}
    return (A)this;
  }
  public A setToHybridClusterNetwork(int index,ClusterNetworkEntry item) {
    if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= hybridClusterNetwork.size()) { _visitables.get("hybridClusterNetwork").add(builder); hybridClusterNetwork.add(builder); } else { _visitables.get("hybridClusterNetwork").set(index, builder); hybridClusterNetwork.set(index, builder);}
    return (A)this;
  }
  public A addToHybridClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
    if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").add(builder);this.hybridClusterNetwork.add(builder);} return (A)this;
  }
  public A addAllToHybridClusterNetwork(Collection<ClusterNetworkEntry> items) {
    if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").add(builder);this.hybridClusterNetwork.add(builder);} return (A)this;
  }
  public A removeFromHybridClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").remove(builder);if (this.hybridClusterNetwork != null) {this.hybridClusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeAllFromHybridClusterNetwork(Collection<ClusterNetworkEntry> items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").remove(builder);if (this.hybridClusterNetwork != null) {this.hybridClusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    if (hybridClusterNetwork == null) return (A) this;
    final Iterator<ClusterNetworkEntryBuilder> each = hybridClusterNetwork.iterator();
    final List visitables = _visitables.get("hybridClusterNetwork");
    while (each.hasNext()) {
      ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHybridClusterNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getHybridClusterNetwork() {
    return hybridClusterNetwork != null ? build(hybridClusterNetwork) : null;
  }
  public List<ClusterNetworkEntry> buildHybridClusterNetwork() {
    return hybridClusterNetwork != null ? build(hybridClusterNetwork) : null;
  }
  public ClusterNetworkEntry buildHybridClusterNetwork(int index) {
    return this.hybridClusterNetwork.get(index).build();
  }
  public ClusterNetworkEntry buildFirstHybridClusterNetwork() {
    return this.hybridClusterNetwork.get(0).build();
  }
  public ClusterNetworkEntry buildLastHybridClusterNetwork() {
    return this.hybridClusterNetwork.get(hybridClusterNetwork.size() - 1).build();
  }
  public ClusterNetworkEntry buildMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: hybridClusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: hybridClusterNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHybridClusterNetwork(List<ClusterNetworkEntry> hybridClusterNetwork) {
    if (this.hybridClusterNetwork != null) { _visitables.get("hybridClusterNetwork").clear();}
    if (hybridClusterNetwork != null) {this.hybridClusterNetwork = new ArrayList(); for (ClusterNetworkEntry item : hybridClusterNetwork){this.addToHybridClusterNetwork(item);}} else { this.hybridClusterNetwork = null;} return (A) this;
  }
  public A withHybridClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... hybridClusterNetwork) {
    if (this.hybridClusterNetwork != null) {this.hybridClusterNetwork.clear(); _visitables.remove("hybridClusterNetwork"); }
    if (hybridClusterNetwork != null) {for (ClusterNetworkEntry item :hybridClusterNetwork){ this.addToHybridClusterNetwork(item);}} return (A) this;
  }
  public Boolean hasHybridClusterNetwork() {
    return hybridClusterNetwork != null && !hybridClusterNetwork.isEmpty();
  }
  public A addNewHybridClusterNetwork(String cidr,Integer hostPrefix) {
    return (A)addToHybridClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  public HybridOverlayConfigFluentImpl.HybridClusterNetworkNested<A> addNewHybridClusterNetwork() {
    return new HybridOverlayConfigFluentImpl.HybridClusterNetworkNestedImpl();
  }
  public HybridOverlayConfigFluentImpl.HybridClusterNetworkNested<A> addNewHybridClusterNetworkLike(ClusterNetworkEntry item) {
    return new HybridOverlayConfigFluentImpl.HybridClusterNetworkNestedImpl(-1, item);
  }
  public HybridOverlayConfigFluentImpl.HybridClusterNetworkNested<A> setNewHybridClusterNetworkLike(int index,ClusterNetworkEntry item) {
    return new HybridOverlayConfigFluentImpl.HybridClusterNetworkNestedImpl(index, item);
  }
  public HybridOverlayConfigFluentImpl.HybridClusterNetworkNested<A> editHybridClusterNetwork(int index) {
    if (hybridClusterNetwork.size() <= index) throw new RuntimeException("Can't edit hybridClusterNetwork. Index exceeds size.");
    return setNewHybridClusterNetworkLike(index, buildHybridClusterNetwork(index));
  }
  public HybridOverlayConfigFluentImpl.HybridClusterNetworkNested<A> editFirstHybridClusterNetwork() {
    if (hybridClusterNetwork.size() == 0) throw new RuntimeException("Can't edit first hybridClusterNetwork. The list is empty.");
    return setNewHybridClusterNetworkLike(0, buildHybridClusterNetwork(0));
  }
  public HybridOverlayConfigFluentImpl.HybridClusterNetworkNested<A> editLastHybridClusterNetwork() {
    int index = hybridClusterNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hybridClusterNetwork. The list is empty.");
    return setNewHybridClusterNetworkLike(index, buildHybridClusterNetwork(index));
  }
  public HybridOverlayConfigFluentImpl.HybridClusterNetworkNested<A> editMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hybridClusterNetwork.size();i++) { 
    if (predicate.test(hybridClusterNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hybridClusterNetwork. No match found.");
    return setNewHybridClusterNetworkLike(index, buildHybridClusterNetwork(index));
  }
  public Integer getHybridOverlayVXLANPort() {
    return this.hybridOverlayVXLANPort;
  }
  public A withHybridOverlayVXLANPort(Integer hybridOverlayVXLANPort) {
    this.hybridOverlayVXLANPort=hybridOverlayVXLANPort; return (A) this;
  }
  public Boolean hasHybridOverlayVXLANPort() {
    return this.hybridOverlayVXLANPort != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HybridOverlayConfigFluentImpl that = (HybridOverlayConfigFluentImpl) o;
    if (!java.util.Objects.equals(hybridClusterNetwork, that.hybridClusterNetwork)) return false;

    if (!java.util.Objects.equals(hybridOverlayVXLANPort, that.hybridOverlayVXLANPort)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(hybridClusterNetwork,  hybridOverlayVXLANPort,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hybridClusterNetwork != null && !hybridClusterNetwork.isEmpty()) { sb.append("hybridClusterNetwork:"); sb.append(hybridClusterNetwork + ","); }
    if (hybridOverlayVXLANPort != null) { sb.append("hybridOverlayVXLANPort:"); sb.append(hybridOverlayVXLANPort + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class HybridClusterNetworkNestedImpl<N> extends ClusterNetworkEntryFluentImpl<HybridOverlayConfigFluentImpl.HybridClusterNetworkNested<N>> implements HybridOverlayConfigFluentImpl.HybridClusterNetworkNested<N>,Nested<N>{
    HybridClusterNetworkNestedImpl(int index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    HybridClusterNetworkNestedImpl() {
      this.index = -1;
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    int index;
    public N and() {
      return (N) HybridOverlayConfigFluentImpl.this.setToHybridClusterNetwork(index,builder.build());
    }
    public N endHybridClusterNetwork() {
      return and();
    }
    
  }
  
}