package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IPsecConfigBuilder extends IPsecConfigFluentImpl<IPsecConfigBuilder> implements VisitableBuilder<IPsecConfig,IPsecConfigBuilder>{
  public IPsecConfigBuilder() {
    this(false);
  }
  public IPsecConfigBuilder(Boolean validationEnabled) {
    this(new IPsecConfig(), validationEnabled);
  }
  public IPsecConfigBuilder(IPsecConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public IPsecConfigBuilder(IPsecConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IPsecConfig(), validationEnabled);
  }
  public IPsecConfigBuilder(IPsecConfigFluent<?> fluent,IPsecConfig instance) {
    this(fluent, instance, false);
  }
  public IPsecConfigBuilder(IPsecConfigFluent<?> fluent,IPsecConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IPsecConfigBuilder(IPsecConfig instance) {
    this(instance,false);
  }
  public IPsecConfigBuilder(IPsecConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IPsecConfigFluent<?> fluent;
  Boolean validationEnabled;
  public IPsecConfig build() {
    IPsecConfig buildable = new IPsecConfig();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}