package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressControllerCaptureHTTPHeadersBuilder extends IngressControllerCaptureHTTPHeadersFluentImpl<IngressControllerCaptureHTTPHeadersBuilder> implements VisitableBuilder<IngressControllerCaptureHTTPHeaders,IngressControllerCaptureHTTPHeadersBuilder>{
  public IngressControllerCaptureHTTPHeadersBuilder() {
    this(false);
  }
  public IngressControllerCaptureHTTPHeadersBuilder(Boolean validationEnabled) {
    this(new IngressControllerCaptureHTTPHeaders(), validationEnabled);
  }
  public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeadersFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeadersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressControllerCaptureHTTPHeaders(), validationEnabled);
  }
  public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeadersFluent<?> fluent,IngressControllerCaptureHTTPHeaders instance) {
    this(fluent, instance, false);
  }
  public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeadersFluent<?> fluent,IngressControllerCaptureHTTPHeaders instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withRequest(instance.getRequest());
      fluent.withResponse(instance.getResponse());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeaders instance) {
    this(instance,false);
  }
  public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeaders instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withRequest(instance.getRequest());
      this.withResponse(instance.getResponse());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressControllerCaptureHTTPHeadersFluent<?> fluent;
  Boolean validationEnabled;
  public IngressControllerCaptureHTTPHeaders build() {
    IngressControllerCaptureHTTPHeaders buildable = new IngressControllerCaptureHTTPHeaders(fluent.getRequest(),fluent.getResponse());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}