package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.openshift.api.model.config.v1.TLSProfileSpec;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface IngressControllerStatusFluent<A extends IngressControllerStatusFluent<A>> extends Fluent<A>{
  public Integer getAvailableReplicas();
  public A withAvailableReplicas(Integer availableReplicas);
  public Boolean hasAvailableReplicas();
  public A addToConditions(int index,OperatorCondition item);
  public A setToConditions(int index,OperatorCondition item);
  public A addToConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items);
  public A addAllToConditions(Collection<OperatorCondition> items);
  public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items);
  public A removeAllFromConditions(Collection<OperatorCondition> items);
  public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<OperatorCondition> getConditions();
  public List<OperatorCondition> buildConditions();
  public OperatorCondition buildCondition(int index);
  public OperatorCondition buildFirstCondition();
  public OperatorCondition buildLastCondition();
  public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
  public A withConditions(List<OperatorCondition> conditions);
  public A withConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... conditions);
  public Boolean hasConditions();
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
  public IngressControllerStatusFluent.ConditionsNested<A> addNewCondition();
  public IngressControllerStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item);
  public IngressControllerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item);
  public IngressControllerStatusFluent.ConditionsNested<A> editCondition(int index);
  public IngressControllerStatusFluent.ConditionsNested<A> editFirstCondition();
  public IngressControllerStatusFluent.ConditionsNested<A> editLastCondition();
  public IngressControllerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
  public String getDomain();
  public A withDomain(String domain);
  public Boolean hasDomain();
  
  /**
   * This method has been deprecated, please use method buildEndpointPublishingStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointPublishingStrategy getEndpointPublishingStrategy();
  public EndpointPublishingStrategy buildEndpointPublishingStrategy();
  public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy);
  public Boolean hasEndpointPublishingStrategy();
  public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy();
  public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item);
  public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy();
  public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy();
  public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item);
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public String getSelector();
  public A withSelector(String selector);
  public Boolean hasSelector();
  public TLSProfileSpec getTlsProfile();
  public A withTlsProfile(TLSProfileSpec tlsProfile);
  public Boolean hasTlsProfile();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,OperatorConditionFluent<IngressControllerStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface EndpointPublishingStrategyNested<N> extends Nested<N>,EndpointPublishingStrategyFluent<IngressControllerStatusFluent.EndpointPublishingStrategyNested<N>>{
    public N and();
    public N endEndpointPublishingStrategy();
    
  }
  
}