package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface KubeAPIServerFluent<A extends KubeAPIServerFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public KubeAPIServerFluent.MetadataNested<A> withNewMetadata();
  public KubeAPIServerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public KubeAPIServerFluent.MetadataNested<A> editMetadata();
  public KubeAPIServerFluent.MetadataNested<A> editOrNewMetadata();
  public KubeAPIServerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubeAPIServerSpec getSpec();
  public KubeAPIServerSpec buildSpec();
  public A withSpec(KubeAPIServerSpec spec);
  public Boolean hasSpec();
  public KubeAPIServerFluent.SpecNested<A> withNewSpec();
  public KubeAPIServerFluent.SpecNested<A> withNewSpecLike(KubeAPIServerSpec item);
  public KubeAPIServerFluent.SpecNested<A> editSpec();
  public KubeAPIServerFluent.SpecNested<A> editOrNewSpec();
  public KubeAPIServerFluent.SpecNested<A> editOrNewSpecLike(KubeAPIServerSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubeAPIServerStatus getStatus();
  public KubeAPIServerStatus buildStatus();
  public A withStatus(KubeAPIServerStatus status);
  public Boolean hasStatus();
  public KubeAPIServerFluent.StatusNested<A> withNewStatus();
  public KubeAPIServerFluent.StatusNested<A> withNewStatusLike(KubeAPIServerStatus item);
  public KubeAPIServerFluent.StatusNested<A> editStatus();
  public KubeAPIServerFluent.StatusNested<A> editOrNewStatus();
  public KubeAPIServerFluent.StatusNested<A> editOrNewStatusLike(KubeAPIServerStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<KubeAPIServerFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,KubeAPIServerSpecFluent<KubeAPIServerFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,KubeAPIServerStatusFluent<KubeAPIServerFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}