package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeAPIServerListBuilder extends KubeAPIServerListFluentImpl<KubeAPIServerListBuilder> implements VisitableBuilder<KubeAPIServerList,KubeAPIServerListBuilder>{
  public KubeAPIServerListBuilder() {
    this(false);
  }
  public KubeAPIServerListBuilder(Boolean validationEnabled) {
    this(new KubeAPIServerList(), validationEnabled);
  }
  public KubeAPIServerListBuilder(KubeAPIServerListFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeAPIServerListBuilder(KubeAPIServerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeAPIServerList(), validationEnabled);
  }
  public KubeAPIServerListBuilder(KubeAPIServerListFluent<?> fluent,KubeAPIServerList instance) {
    this(fluent, instance, false);
  }
  public KubeAPIServerListBuilder(KubeAPIServerListFluent<?> fluent,KubeAPIServerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeAPIServerListBuilder(KubeAPIServerList instance) {
    this(instance,false);
  }
  public KubeAPIServerListBuilder(KubeAPIServerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeAPIServerListFluent<?> fluent;
  Boolean validationEnabled;
  public KubeAPIServerList build() {
    KubeAPIServerList buildable = new KubeAPIServerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}