package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeAPIServerStatusBuilder extends KubeAPIServerStatusFluentImpl<KubeAPIServerStatusBuilder> implements VisitableBuilder<KubeAPIServerStatus,KubeAPIServerStatusBuilder>{
  public KubeAPIServerStatusBuilder() {
    this(false);
  }
  public KubeAPIServerStatusBuilder(Boolean validationEnabled) {
    this(new KubeAPIServerStatus(), validationEnabled);
  }
  public KubeAPIServerStatusBuilder(KubeAPIServerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeAPIServerStatusBuilder(KubeAPIServerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeAPIServerStatus(), validationEnabled);
  }
  public KubeAPIServerStatusBuilder(KubeAPIServerStatusFluent<?> fluent,KubeAPIServerStatus instance) {
    this(fluent, instance, false);
  }
  public KubeAPIServerStatusBuilder(KubeAPIServerStatusFluent<?> fluent,KubeAPIServerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      fluent.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason());
      fluent.withNodeStatuses(instance.getNodeStatuses());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeAPIServerStatusBuilder(KubeAPIServerStatus instance) {
    this(instance,false);
  }
  public KubeAPIServerStatusBuilder(KubeAPIServerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      this.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason());
      this.withNodeStatuses(instance.getNodeStatuses());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeAPIServerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KubeAPIServerStatus build() {
    KubeAPIServerStatus buildable = new KubeAPIServerStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getLatestAvailableRevision(),fluent.getLatestAvailableRevisionReason(),fluent.getNodeStatuses(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}